/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.message;

import java.util.Optional;
import org.activiti.cloud.services.events.message.MessageBuilderAppender;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.lang.Nullable;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class ExecutionContextMessageBuilderAppender
implements MessageBuilderAppender {
    private final ExecutionContext executionContext;

    public ExecutionContextMessageBuilderAppender(@Nullable ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public <P> MessageBuilder<P> apply(MessageBuilder<P> request) {
        Assert.notNull(request, (String)"request must not be null");
        if (this.executionContext != null) {
            ExecutionEntity processInstance = this.executionContext.getProcessInstance();
            ProcessDefinition processDefinition = this.executionContext.getProcessDefinition();
            DeploymentEntity deploymentEntity = this.executionContext.getDeployment();
            if (processInstance != null) {
                request.setHeader("rootBusinessKey", (Object)processInstance.getBusinessKey()).setHeader("rootProcessInstanceId", (Object)processInstance.getId()).setHeader("rootProcessName", (Object)processInstance.getName());
                this.applyParent(processInstance, request);
            }
            if (processDefinition != null) {
                request.setHeader("rootProcessDefinitionId", (Object)processDefinition.getId()).setHeader("rootProcessDefinitionKey", (Object)processDefinition.getKey()).setHeader("rootProcessDefinitionVersion", (Object)processDefinition.getVersion()).setHeader("rootProcessDefinitionName", (Object)processDefinition.getName());
            }
            if (deploymentEntity != null) {
                request.setHeader("deploymentId", (Object)deploymentEntity.getId()).setHeader("deploymentName", (Object)deploymentEntity.getName()).setHeader("deploymentVersion", (Object)deploymentEntity.getVersion());
            }
        }
        return request;
    }

    protected <P> MessageBuilder<P> applyParent(ExecutionEntity processInstance, MessageBuilder<P> request) {
        if (processInstance.getSuperExecutionId() != null) {
            Optional.ofNullable(processInstance.getSuperExecution()).ifPresent(superExecution -> {
                request.setHeader("parentProcessInstanceId", (Object)superExecution.getProcessInstanceId());
                if (superExecution.getProcessInstanceId() != null) {
                    Optional.ofNullable(superExecution.getProcessInstance()).ifPresent(parentInstance -> request.setHeader("parentProcessInstanceName", (Object)parentInstance.getName()));
                }
            });
        }
        return request;
    }
}

