/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;

public class EventChunker {
    private final ObjectMapper objectMapper;
    private final RuntimeBundleProperties runtimeBundleProperties;

    public EventChunker(ObjectMapper objectMapper, RuntimeBundleProperties runtimeBundleProperties) {
        this.objectMapper = objectMapper;
        this.runtimeBundleProperties = runtimeBundleProperties;
    }

    public Collection<List<CloudRuntimeEventImpl<?, ?>>> chunk(List<CloudRuntimeEventImpl<?, ?>> events) {
        ArrayList chunks = new ArrayList();
        ArrayList currentChunk = new ArrayList();
        int currentChunkSize = 0;
        for (CloudRuntimeEventImpl<?, ?> event : events) {
            int eventSizeInBytes = this.getEventSizeInBytes(event);
            if (this.isSingleEventExceedingMaxLimit(eventSizeInBytes)) {
                throw new IllegalArgumentException("Chunk size limit exceeded");
            }
            if (this.wouldChunkExceedMaxLimit(currentChunkSize, eventSizeInBytes, currentChunk)) {
                chunks.add(new ArrayList(currentChunk));
                currentChunk.clear();
                currentChunkSize = 0;
            }
            currentChunk.add(event);
            currentChunkSize += eventSizeInBytes;
        }
        if (!currentChunk.isEmpty()) {
            chunks.add(currentChunk);
        }
        return chunks;
    }

    private boolean isSingleEventExceedingMaxLimit(int eventSizeInBytes) {
        return eventSizeInBytes > this.runtimeBundleProperties.getEventsProperties().getChunkSizeInBytesCloseListener();
    }

    private boolean wouldChunkExceedMaxLimit(int currentChunkSize, int eventSizeInBytes, List<CloudRuntimeEventImpl<?, ?>> currentChunk) {
        return currentChunkSize + eventSizeInBytes > this.runtimeBundleProperties.getEventsProperties().getChunkSizeInBytesCloseListener() && !currentChunk.isEmpty();
    }

    private int getEventSizeInBytes(CloudRuntimeEventImpl<?, ?> event) {
        try {
            return this.objectMapper.writeValueAsBytes(event).length;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize event to JSON", e);
        }
    }
}

