/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.listeners;

import org.activiti.api.process.model.Deployment;
import org.activiti.api.process.model.events.ApplicationEvent;
import org.activiti.api.runtime.event.impl.ApplicationDeployedEvents;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudApplicationDeployedEventImpl;
import org.activiti.cloud.services.events.ProcessEngineChannels;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.RuntimeBundleMessageBuilderFactory;
import org.springframework.context.event.EventListener;

public class CloudApplicationDeployedProducer {
    private RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private ProcessEngineChannels producer;
    private RuntimeBundleMessageBuilderFactory runtimeBundleMessageBuilderFactory;

    public CloudApplicationDeployedProducer(RuntimeBundleInfoAppender runtimeBundleInfoAppender, ProcessEngineChannels producer, RuntimeBundleMessageBuilderFactory runtimeBundleMessageBuilderFactory) {
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.producer = producer;
        this.runtimeBundleMessageBuilderFactory = runtimeBundleMessageBuilderFactory;
    }

    @EventListener
    public void sendApplicationDeployedEvents(ApplicationDeployedEvents applicationDeployedEvents) {
        this.producer.auditProducer().send(this.runtimeBundleMessageBuilderFactory.create().withPayload((CloudRuntimeEvent[])applicationDeployedEvents.getApplicationDeployedEvents().stream().map(applicationDeployedEvent -> {
            CloudApplicationDeployedEventImpl cloudApplicationDeployedEvent = new CloudApplicationDeployedEventImpl(applicationDeployedEvent.getId(), applicationDeployedEvent.getTimestamp(), (Deployment)applicationDeployedEvent.getEntity(), (ApplicationEvent.ApplicationEvents)applicationDeployedEvent.getEventType());
            this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudApplicationDeployedEvent);
            return cloudApplicationDeployedEvent;
        }).toArray(CloudRuntimeEvent[]::new)).build());
    }
}

