/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.listeners;

import java.util.Collection;
import java.util.List;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.services.events.ProcessEngineChannels;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.EventChunker;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.cloud.services.events.services.IncidentService;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandContextCloseListener;
import org.springframework.messaging.Message;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Transactional
public class MessageProducerCommandContextCloseListener
implements CommandContextCloseListener {
    public static final String ROOT_EXECUTION_CONTEXT = "rootExecutionContext";
    public static final String PROCESS_ENGINE_EVENTS = "processEngineEvents";
    private final ProcessEngineChannels producer;
    private final MessageBuilderChainFactory<ExecutionContext> messageBuilderChainFactory;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private RuntimeBundleProperties runtimeBundleProperties;
    private final EventChunker eventChunker;
    private final IncidentService incidentService;

    public MessageProducerCommandContextCloseListener(ProcessEngineChannels producer, MessageBuilderChainFactory<ExecutionContext> messageBuilderChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender, RuntimeBundleProperties runtimeBundleProperties, EventChunker eventChunker, IncidentService incidentService) {
        Assert.notNull((Object)producer, (String)"producer must not be null");
        Assert.notNull(messageBuilderChainFactory, (String)"messageBuilderChainFactory must not be null");
        Assert.notNull((Object)runtimeBundleInfoAppender, (String)"runtimeBundleInfoAppender must not be null");
        Assert.notNull((Object)eventChunker, (String)"eventChunker must not be null");
        Assert.notNull((Object)incidentService, (String)"incidentService must not be null");
        this.producer = producer;
        this.messageBuilderChainFactory = messageBuilderChainFactory;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.runtimeBundleProperties = runtimeBundleProperties;
        this.eventChunker = eventChunker;
        this.incidentService = incidentService;
    }

    public void closed(CommandContext commandContext) {
        List events = (List)commandContext.getGenericAttribute(PROCESS_ENGINE_EVENTS);
        if (CollectionUtils.isEmpty((Collection)events)) {
            return;
        }
        ExecutionContext rootExecutionContext = (ExecutionContext)commandContext.getGenericAttribute(ROOT_EXECUTION_CONTEXT);
        this.sendEvents(events, rootExecutionContext);
    }

    public void closing(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public void closeFailure(CommandContext commandContext) {
    }

    private void sendEvents(List<CloudRuntimeEvent<?, ?>> events, ExecutionContext rootExecutionContext) {
        try {
            Collection<List<CloudRuntimeEventImpl<?, ?>>> eventChunks = this.createEventChunks(events);
            eventChunks.forEach(chunk -> this.sendChunk(rootExecutionContext, (List<CloudRuntimeEventImpl<?, ?>>)chunk));
        }
        catch (IllegalArgumentException e) {
            this.incidentService.createAndSendIncidentEvent(rootExecutionContext, e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private Collection<List<CloudRuntimeEventImpl<?, ?>>> createEventChunks(List<CloudRuntimeEvent<?, ?>> events) {
        List<CloudRuntimeEventImpl<?, ?>> processedEvents = this.processEvents(events);
        if (this.isChunkingDisabled()) {
            return List.of(processedEvents);
        }
        return this.eventChunker.chunk(processedEvents);
    }

    private List<CloudRuntimeEventImpl<?, ?>> processEvents(List<CloudRuntimeEvent<?, ?>> events) {
        return events.stream().filter(CloudRuntimeEventImpl.class::isInstance).map(CloudRuntimeEventImpl.class::cast).map(this.runtimeBundleInfoAppender::appendRuntimeBundleInfoTo).toList();
    }

    private void sendChunk(ExecutionContext rootExecutionContext, List<CloudRuntimeEventImpl<?, ?>> chunk) {
        CloudRuntimeEvent[] eventArray = (CloudRuntimeEvent[])chunk.toArray(CloudRuntimeEvent[]::new);
        Message message = this.messageBuilderChainFactory.create(rootExecutionContext).withPayload(eventArray).build();
        this.producer.auditProducer().send(message);
    }

    private boolean isChunkingDisabled() {
        return this.runtimeBundleProperties.getEventsProperties().isChunkingCloseListenerDisabled();
    }
}

