/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.converter;

import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.TaskCandidateGroup;
import org.activiti.api.task.model.TaskCandidateUser;
import org.activiti.api.task.runtime.events.TaskActivatedEvent;
import org.activiti.api.task.runtime.events.TaskAssignedEvent;
import org.activiti.api.task.runtime.events.TaskCancelledEvent;
import org.activiti.api.task.runtime.events.TaskCandidateGroupAddedEvent;
import org.activiti.api.task.runtime.events.TaskCandidateGroupRemovedEvent;
import org.activiti.api.task.runtime.events.TaskCandidateUserAddedEvent;
import org.activiti.api.task.runtime.events.TaskCandidateUserRemovedEvent;
import org.activiti.api.task.runtime.events.TaskCompletedEvent;
import org.activiti.api.task.runtime.events.TaskCreatedEvent;
import org.activiti.api.task.runtime.events.TaskSuspendedEvent;
import org.activiti.api.task.runtime.events.TaskUpdatedEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.task.model.events.CloudTaskActivatedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskAssignedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCancelledEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateGroupAddedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateGroupRemovedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateUserAddedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateUserRemovedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCompletedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCreatedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskSuspendedEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskUpdatedEvent;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskActivatedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskAssignedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCancelledEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateGroupAddedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateGroupRemovedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateUserAddedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateUserRemovedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCompletedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCreatedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskSuspendedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskUpdatedEventImpl;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.converter.TaskAuditServiceInfoAppender;

public class ToCloudTaskRuntimeEventConverter {
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private final TaskAuditServiceInfoAppender auditServiceInfoAppender;

    public ToCloudTaskRuntimeEventConverter(RuntimeBundleInfoAppender runtimeBundleInfoAppender, TaskAuditServiceInfoAppender auditServiceInfoAppender) {
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.auditServiceInfoAppender = auditServiceInfoAppender;
    }

    public CloudTaskCreatedEvent from(TaskCreatedEvent event) {
        CloudTaskCreatedEventImpl cloudEvent = new CloudTaskCreatedEventImpl((Task)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskUpdatedEvent from(TaskUpdatedEvent event) {
        CloudTaskUpdatedEventImpl cloudEvent = new CloudTaskUpdatedEventImpl((Task)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskAssignedEvent from(TaskAssignedEvent event) {
        CloudTaskAssignedEventImpl cloudEvent = new CloudTaskAssignedEventImpl((Task)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskCompletedEvent from(TaskCompletedEvent event) {
        CloudTaskCompletedEventImpl cloudEvent = new CloudTaskCompletedEventImpl((Task)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        this.auditServiceInfoAppender.appendAuditServiceInfoTo(cloudEvent);
        return cloudEvent;
    }

    public CloudTaskCancelledEvent from(TaskCancelledEvent event) {
        CloudTaskCancelledEventImpl cloudEvent = new CloudTaskCancelledEventImpl((Task)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskSuspendedEvent from(TaskSuspendedEvent event) {
        CloudTaskSuspendedEventImpl cloudEvent = new CloudTaskSuspendedEventImpl((Task)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskActivatedEvent from(TaskActivatedEvent event) {
        CloudTaskActivatedEventImpl cloudEvent = new CloudTaskActivatedEventImpl((Task)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskCandidateUserAddedEvent from(TaskCandidateUserAddedEvent event) {
        CloudTaskCandidateUserAddedEventImpl cloudEvent = new CloudTaskCandidateUserAddedEventImpl((TaskCandidateUser)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskCandidateUserRemovedEvent from(TaskCandidateUserRemovedEvent event) {
        CloudTaskCandidateUserRemovedEventImpl cloudEvent = new CloudTaskCandidateUserRemovedEventImpl((TaskCandidateUser)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskCandidateGroupAddedEvent from(TaskCandidateGroupAddedEvent event) {
        CloudTaskCandidateGroupAddedEventImpl cloudEvent = new CloudTaskCandidateGroupAddedEventImpl((TaskCandidateGroup)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }

    public CloudTaskCandidateGroupRemovedEvent from(TaskCandidateGroupRemovedEvent event) {
        CloudTaskCandidateGroupRemovedEventImpl cloudEvent = new CloudTaskCandidateGroupRemovedEventImpl((TaskCandidateGroup)event.getEntity());
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)cloudEvent);
        return cloudEvent;
    }
}

