/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.job.executor;

import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.springframework.cloud.stream.config.BindingServiceProperties;

public class DefaultMessageBasedJobManagerFactory implements MessageBasedJobManagerFactory {

    private final BindingServiceProperties bindingServiceProperties;
    private final JobMessageProducer jobMessageProducer;

    public DefaultMessageBasedJobManagerFactory(
        BindingServiceProperties bindingServiceProperties,
        JobMessageProducer jobMessageProducer
    ) {
        this.bindingServiceProperties = bindingServiceProperties;
        this.jobMessageProducer = jobMessageProducer;
    }

    @Override
    public MessageBasedJobManager create(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return new MessageBasedJobManager(processEngineConfiguration, bindingServiceProperties, jobMessageProducer);
    }
}
