/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.messages.events.producer;

import org.activiti.api.process.model.BPMNMessage;
import org.activiti.api.process.model.events.BPMNMessageEvent;
import org.activiti.api.process.model.events.BPMNMessageReceivedEvent;
import org.activiti.api.process.runtime.events.listener.BPMNElementEventListener;
import org.activiti.cloud.services.messages.events.support.BpmnMessageEventMessageBuilderFactory;
import org.activiti.cloud.services.messages.events.support.MessageEventsDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;

public class BpmnMessageReceivedEventMessageProducer
implements BPMNElementEventListener<BPMNMessageReceivedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(BpmnMessageReceivedEventMessageProducer.class);
    private final BpmnMessageEventMessageBuilderFactory messageBuilderFactory;
    private final MessageEventsDispatcher messageEventsDispatcher;

    public BpmnMessageReceivedEventMessageProducer(@NonNull MessageEventsDispatcher messageEventsDispatcher, @NonNull BpmnMessageEventMessageBuilderFactory messageBuilderFactory) {
        this.messageEventsDispatcher = messageEventsDispatcher;
        this.messageBuilderFactory = messageBuilderFactory;
    }

    public void onEvent(@NonNull BPMNMessageReceivedEvent event) {
        logger.debug("onEvent: {}", (Object)event);
        Message message = this.messageBuilderFactory.create((BPMNMessage)event.getEntity()).withPayload((Object)((BPMNMessage)event.getEntity()).getMessagePayload()).setHeader("messageEventType", (Object)((BPMNMessageEvent.MessageEvents)event.getEventType()).name()).build();
        this.messageEventsDispatcher.dispatch(message);
    }
}

