/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.messages.events.producer;

import org.activiti.api.process.model.StartMessageDeploymentDefinition;
import org.activiti.api.process.model.StartMessageSubscription;
import org.activiti.api.process.model.builders.MessageEventPayloadBuilder;
import org.activiti.api.process.model.events.StartMessageDeployedEvent;
import org.activiti.api.process.model.payloads.MessageEventPayload;
import org.activiti.api.process.runtime.events.listener.ProcessRuntimeEventListener;
import org.activiti.cloud.services.messages.events.producer.BpmnMessageSentEventMessageProducer;
import org.activiti.cloud.services.messages.events.support.MessageEventsDispatcher;
import org.activiti.cloud.services.messages.events.support.StartMessageDeployedEventMessageBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;

public class StartMessageDeployedEventMessageProducer
implements ProcessRuntimeEventListener<StartMessageDeployedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(BpmnMessageSentEventMessageProducer.class);
    private final StartMessageDeployedEventMessageBuilderFactory messageBuilderFactory;
    private final MessageEventsDispatcher messageEventsDispatcher;

    public StartMessageDeployedEventMessageProducer(@NonNull MessageEventsDispatcher messageEventsDispatcher, @NonNull StartMessageDeployedEventMessageBuilderFactory messageBuilderFactory) {
        this.messageEventsDispatcher = messageEventsDispatcher;
        this.messageBuilderFactory = messageBuilderFactory;
    }

    public void onEvent(StartMessageDeployedEvent event) {
        logger.debug("onEvent: {}", (Object)event);
        StartMessageSubscription messageSubscription = ((StartMessageDeploymentDefinition)event.getEntity()).getMessageSubscription();
        MessageEventPayload messageEventPayload = MessageEventPayloadBuilder.messageEvent((String)messageSubscription.getEventName()).withCorrelationKey(messageSubscription.getConfiguration()).build();
        Message message = this.messageBuilderFactory.create(event).withPayload((Object)messageEventPayload).setHeader("messageEventType", (Object)event.getEventType().name()).build();
        this.messageEventsDispatcher.dispatch(message);
    }
}

