/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.messages.events.support;

import org.activiti.api.process.model.events.StartMessageDeployedEvent;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.events.message.MessageBuilderAppenderChain;
import org.activiti.cloud.services.events.message.RuntimeBundleInfoMessageBuilderAppender;

public class StartMessageDeployedEventMessageBuilderFactory {

    private final RuntimeBundleProperties properties;

    public StartMessageDeployedEventMessageBuilderFactory(RuntimeBundleProperties properties) {
        this.properties = properties;
    }

    public MessageBuilderAppenderChain create(StartMessageDeployedEvent messageDeployedEvent) {
        return new MessageBuilderAppenderChain()
            .chain(new RuntimeBundleInfoMessageBuilderAppender(properties))
            .chain(new StartMessageDeploymentDefinitionMessageBuilderAppender(messageDeployedEvent.getEntity()));
    }
}
