/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.metadata;

import java.util.HashMap;
import java.util.Map;
import org.activiti.cloud.services.metadata.MetadataProperties;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataService {
    private MetadataProperties metadataProperties;
    private final String servicePrefix = "activiti-cloud-service-";
    private final String applicationPrefix = "activiti-cloud-application-";

    @Autowired
    public MetadataService(MetadataProperties metadataProperties) {
        this.metadataProperties = metadataProperties;
    }

    public String getKeyAsMetaData(String key, String keyPrefix) {
        return keyPrefix + key.replace(".", "-");
    }

    public Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (String key : this.metadataProperties.getApplication().keySet()) {
            if (this.metadataProperties.getApplication().get(key) == null) continue;
            metadata.put(this.getKeyAsMetaData(key, "activiti-cloud-application-"), this.metadataProperties.getApplication().get(key));
        }
        for (String key : this.metadataProperties.getService().keySet()) {
            if (this.metadataProperties.getService().get(key) == null) continue;
            metadata.put(this.getKeyAsMetaData(key, "activiti-cloud-service-"), this.metadataProperties.getService().get(key));
        }
        return metadata;
    }
}

