/*
 * Copyright 2017-2026 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.metadata;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties("activiti.cloud")
public class MetadataProperties implements InitializingBean {

    private Map<String, String> application = new HashMap<String, String>();
    private Map<String, String> service = new HashMap<String, String>();

    public Map<String, String> getApplication() {
        return this.application;
    }

    public Map<String, String> getService() {
        return this.service;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // do nothing
    }
}
