/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.activiti.cloud.services.notifications.graphql.ws.api.GraphQLMessageType;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class GraphQLMessage {
    private Map<String, Object> payload;
    private String id;
    private GraphQLMessageType type;

    private GraphQLMessage(Builder builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.payload = builder.payload;
    }

    GraphQLMessage() {
    }

    public GraphQLMessage(String id, GraphQLMessageType type) {
        this(id, type, Collections.emptyMap());
    }

    public GraphQLMessage(String id, GraphQLMessageType type, Map<String, Object> payload) {
        this.payload = payload;
        this.id = id;
        this.type = type;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public String getId() {
        return this.id;
    }

    public GraphQLMessageType getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphQLMessage)) {
            return false;
        }
        GraphQLMessage otherMsg = (GraphQLMessage)other;
        return Objects.equals(this.payload, otherMsg.getPayload());
    }

    public int hashCode() {
        return Objects.hashCode(this.payload) * 23;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" [payload=");
        sb.append(this.payload);
        sb.append(", id=").append(this.id);
        sb.append(", type=").append((Object)this.type).append("]");
        return sb.toString();
    }

    public static ITypeStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements ITypeStage,
    IBuildStage {
        private GraphQLMessageType type;
        private String id;
        private Map<String, Object> payload = Collections.emptyMap();

        private Builder() {
        }

        @Override
        public IBuildStage type(GraphQLMessageType type) {
            this.type = type;
            return this;
        }

        @Override
        public IBuildStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public IBuildStage payload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public GraphQLMessage build() {
            return new GraphQLMessage(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage id(String var1);

        public IBuildStage payload(Map<String, Object> var1);

        public GraphQLMessage build();
    }

    public static interface ITypeStage {
        public IBuildStage type(GraphQLMessageType var1);
    }
}

