/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.web.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GraphQLQueryResult {
    private Map<String, Object> data;
    private List<Map<String, Object>> errors;
    private Map<Object, Object> extensions;

    private GraphQLQueryResult(Builder builder) {
        this.data = builder.data;
        this.errors = builder.errors;
        this.extensions = builder.extensions;
    }

    GraphQLQueryResult() {
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    public static Builder builderFrom(GraphQLQueryResult graphQLQueryResult) {
        return new Builder(graphQLQueryResult);
    }

    public static final class Builder {
        private Map<String, Object> data = Collections.emptyMap();
        private List<Map<String, Object>> errors = Collections.emptyList();
        private Map<Object, Object> extensions = Collections.emptyMap();

        public Builder() {
        }

        private Builder(GraphQLQueryResult graphQLQueryResult) {
            this.data = graphQLQueryResult.data;
            this.errors = graphQLQueryResult.errors;
            this.extensions = graphQLQueryResult.extensions;
        }

        public Builder withData(Map<String, Object> data) {
            this.data = data;
            return this;
        }

        public Builder withErrors(List<Map<String, Object>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder withExtensions(Map<Object, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public GraphQLQueryResult build() {
            return new GraphQLQueryResult(this);
        }
    }
}

