/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum GraphQLMessageType {
    CONNECTION_INIT("connection_init"),
    CONNECTION_ACK("connection_ack"),
    CONNECTION_ERROR("connection_error"),
    KA("ka"),
    CONNECTION_TERMINATE("connection_terminate"),
    START("start"),
    DATA("data"),
    ERROR("error"),
    COMPLETE("complete"),
    STOP("stop");

    private final String type;
    private static final Map<String, GraphQLMessageType> lookup;

    private GraphQLMessageType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static GraphQLMessageType get(String type) {
        return lookup.get(type);
    }

    @JsonValue
    public String toString() {
        return this.type;
    }

    static {
        lookup = new HashMap<String, GraphQLMessageType>();
        for (GraphQLMessageType env : GraphQLMessageType.values()) {
            lookup.put(env.type, env);
        }
    }
}

