/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.graphiql;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnWebApplication
public class GraphiQLConfigController {
    @Value(value="${graphiql.graphql.web.path:/graphql}")
    private String graphqlWebPath;
    @Value(value="${graphiql.graphql.ws.path:/ws/graphql}")
    private String graphqlWsPath;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;

    @GetMapping(value={"graphiql/config.js"}, produces={"application/javascript"})
    @ResponseStatus(value=HttpStatus.OK)
    public String getConfigJs() {
        String config = "window.GraphqlApi = {   graphqlWebPath: \"" + this.getGraphQLWebPath() + "\",   graphqlWsPath: \"" + this.getGraphQLWsPath() + "\"}";
        return config;
    }

    @GetMapping(value={"graphiql/config.json"}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> getGraphiqlJson() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("graphqlWebPath", this.getGraphQLWebPath());
        values.put("graphqlWsPath", this.getGraphQLWsPath());
        return ResponseEntity.ok(values);
    }

    public String getGraphQLWebPath() {
        return this.appendSegmentToPath(this.contextPath, this.graphqlWebPath);
    }

    public String getGraphQLWsPath() {
        return this.appendSegmentToPath(this.contextPath, this.graphqlWsPath);
    }

    public String appendSegmentToPath(String path, String segment) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return segment;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (segment.startsWith("/")) {
            return path + segment;
        }
        return path + "/" + segment;
    }
}

