/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.qraphql.ws.security;

import java.util.Map;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.WebSocketGraphQlRequest;
import org.springframework.graphql.server.WebSocketSessionInfo;
import org.springframework.graphql.server.support.AbstractAuthenticationWebSocketInterceptor;
import org.springframework.graphql.server.support.AuthenticationExtractor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class SecurityWebSocketInterceptor
extends AbstractAuthenticationWebSocketInterceptor {
    private final String authenticationAttribute = ((Object)((Object)this)).getClass().getName() + ".AUTHENTICATION";
    private final AuthenticationManager authenticationManager;
    private final AuthorizationManager<?> authorizationManager;

    public SecurityWebSocketInterceptor(AuthenticationExtractor authExtractor, AuthenticationManager authenticationManager, AuthorizationManager<?> authorizationManager) {
        super(authExtractor);
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
    }

    public Mono<Object> handleConnectionInitialization(WebSocketSessionInfo info, Map<String, Object> payload) {
        if (!payload.containsKey("Authorization")) {
            payload.put("Authorization", "");
        }
        return super.handleConnectionInitialization(info, payload).doOnNext(o -> this.authorize(info)).switchIfEmpty(Mono.defer(() -> {
            this.authorize(info);
            return Mono.empty();
        }));
    }

    protected Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.just((Object)this.authenticationManager.authenticate(authentication));
    }

    protected ContextView getContextToWrite(SecurityContext securityContext) {
        String key = SecurityContext.class.getName();
        return Context.of((Object)key, (Object)securityContext);
    }

    public Mono<WebGraphQlResponse> intercept(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        if (!(request instanceof WebSocketGraphQlRequest)) {
            return chain.next(request);
        }
        WebSocketGraphQlRequest webSocketRequest = (WebSocketGraphQlRequest)request;
        this.authorize(webSocketRequest.getSessionInfo());
        return super.intercept(request, chain);
    }

    private void authorize(WebSocketSessionInfo sessionInfo) {
        Map attributes = sessionInfo.getAttributes();
        SecurityContext securityContext = (SecurityContext)attributes.get(this.authenticationAttribute);
        AuthorizationDecision authorizationDecision = this.authorizationManager.check(() -> ((SecurityContext)securityContext).getAuthentication(), null);
        if (authorizationDecision != null && !authorizationDecision.isGranted()) {
            throw new AuthorizationDeniedException("Access denied", (AuthorizationResult)authorizationDecision);
        }
    }
}

