/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.qraphql.ws.security;

import java.util.Collection;
import java.util.Set;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JWSAuthentication;
import org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.GraphQLAccessToken;
import org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.GraphQLAccessTokenVerifier;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.User;

@Qualifier(value="websoket")
public class JWSAuthenticationManager
implements AuthenticationManager {
    private final GraphQLAccessTokenVerifier tokenVerifier;
    private Attributes2GrantedAuthoritiesMapper authoritiesMapper = new SimpleAttributes2GrantedAuthoritiesMapper();

    public JWSAuthenticationManager(GraphQLAccessTokenVerifier tokenVerifier) {
        this.tokenVerifier = tokenVerifier;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JWSAuthentication token = null;
        try {
            if (authentication instanceof JWSAuthentication) {
                token = (JWSAuthentication)((Object)JWSAuthentication.class.cast(authentication));
                String credentials = (String)token.getCredentials();
                GraphQLAccessToken accessToken = this.tokenVerifier.verifyToken(credentials);
                Set<String> roles = accessToken.getRoles();
                String preferredUsername = accessToken.getUsername();
                Collection authorities = this.authoritiesMapper.getGrantedAuthorities(roles);
                User user = new User(preferredUsername, credentials, authorities);
                token = new JWSAuthentication(credentials, user, authorities);
                token.setDetails(accessToken);
            }
        }
        catch (Exception e) {
            throw new BadCredentialsException("Invalid token", (Throwable)e);
        }
        return token;
    }

    public void setAuthoritiesMapper(Attributes2GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }
}

