/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.qraphql.ws.security;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JWSAuthentication;
import org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.GraphQLAccessTokenVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Order(value=-2147483549)
public class JwtInterceptorConfigurer
implements WebSocketMessageBrokerConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(JwtInterceptorConfigurer.class);
    private static final String GRAPHQL_MESSAGE_TYPE = "graphQLMessageType";
    private final GraphQLAccessTokenVerifier tokenVerifier;
    private List<String> headerValues = Arrays.asList("connection_init", "start");
    private String headerName = "graphQLMessageType";

    public JwtInterceptorConfigurer(GraphQLAccessTokenVerifier tokenVerifier) {
        this.tokenVerifier = tokenVerifier;
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new ChannelInterceptor(){

            public Message<?> preSend(Message<?> message, MessageChannel channel) {
                SimpMessageHeaderAccessor accessor = (SimpMessageHeaderAccessor)MessageHeaderAccessor.getAccessor(message, SimpMessageHeaderAccessor.class);
                if (accessor != null && JwtInterceptorConfigurer.this.headerValues.contains(accessor.getHeader(JwtInterceptorConfigurer.this.headerName))) {
                    Optional.ofNullable(accessor.getUser()).filter(JWSAuthentication.class::isInstance).map(JWSAuthentication.class::cast).ifPresent(jWSAuthentication -> {
                        try {
                            logger.info("Verifying Access Token for {}", accessor.getHeader(JwtInterceptorConfigurer.GRAPHQL_MESSAGE_TYPE));
                            JwtInterceptorConfigurer.this.tokenVerifier.verifyToken((String)jWSAuthentication.getCredentials());
                        }
                        catch (Exception e) {
                            throw new BadCredentialsException("Invalid token", (Throwable)e);
                        }
                    });
                }
                return message;
            }
        }});
    }

    public void setHeaderValues(List<String> headerValues) {
        this.headerValues = headerValues;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }
}

