/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.function.Predicate;
import org.activiti.cloud.services.notifications.graphql.events.RoutingKeyResolver;
import org.activiti.cloud.services.notifications.graphql.events.model.EngineEvent;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.AntPathDestinationResolver;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.DataFetcherDestinationResolver;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsPredicateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class EngineEventsDestinationsPredicateFactory
implements EngineEventsPredicateFactory {
    private static Logger logger = LoggerFactory.getLogger(EngineEventsDestinationsPredicateFactory.class);
    private final RoutingKeyResolver routingKeyResolver;
    private DataFetcherDestinationResolver destinationResolver = new AntPathDestinationResolver();
    private AntPathMatcher pathMatcher = new AntPathMatcher(".");

    public EngineEventsDestinationsPredicateFactory(RoutingKeyResolver routingKeyResolver) {
        this.routingKeyResolver = routingKeyResolver;
    }

    @Override
    public Predicate<? super EngineEvent> getPredicate(DataFetchingEnvironment environment) {
        List<String> destinations = this.destinationResolver.resolveDestinations(environment);
        logger.info("Resolved destinations {} for environment: {}", destinations, (Object)environment);
        return engineEvent -> {
            String routingKey = this.routingKeyResolver.resolveRoutingKey(engineEvent);
            logger.debug("Resolved routing key {} for {}", (Object)routingKey, engineEvent);
            return destinations.stream().anyMatch(pattern -> this.pathMatcher.match(pattern, routingKey));
        };
    }

    public EngineEventsDestinationsPredicateFactory destinationResolver(DataFetcherDestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
        return this;
    }

    public EngineEventsDestinationsPredicateFactory pathMatcher(AntPathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
        return this;
    }
}

