/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.subscriptions.config;

import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaConfigurer;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLShemaRegistration;
import graphql.GraphQL;
import java.util.List;
import org.activiti.cloud.services.notifications.graphql.events.RoutingKeyResolver;
import org.activiti.cloud.services.notifications.graphql.events.model.EngineEvent;
import org.activiti.cloud.services.notifications.graphql.subscriptions.GraphQLSubscriptionSchemaBuilder;
import org.activiti.cloud.services.notifications.graphql.subscriptions.GraphQLSubscriptionSchemaProperties;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsDestinationsPredicateFactory;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsFluxPublisherFactory;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsPredicateFactory;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsPublisherDataFetcher;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsPublisherFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.ReactorNettyTcpStompClient;
import reactor.core.publisher.Flux;

@AutoConfiguration
@ConditionalOnClass(value={GraphQL.class, ReactorNettyTcpStompClient.class})
@ConditionalOnProperty(name={"spring.activiti.cloud.services.notifications.graphql.subscriptions.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GraphQLSubscriptionSchemaProperties.class})
@PropertySources(value={@PropertySource(value={"classpath:META-INF/graphql-subscriptions.properties"}), @PropertySource(value={"classpath:graphql-subscriptions.properties"}, ignoreResourceNotFound=true)})
public class GraphQLSubscriptionsAutoConfiguration {

    @Configuration
    static class DefaultGraphQLSubscriptionsConfigurer
    implements GraphQLSchemaConfigurer {
        @Autowired
        private GraphQLSubscriptionSchemaBuilder graphQLSubscriptionSchemaBuilder;

        DefaultGraphQLSubscriptionsConfigurer() {
        }

        public void configure(GraphQLShemaRegistration registry) {
            registry.register(this.graphQLSubscriptionSchemaBuilder.getGraphQLSchema());
        }
    }

    @Configuration
    static class DefaultGraphQLSubscriptionsSchemaConfiguration {
        @Autowired
        private GraphQLSubscriptionSchemaProperties subscriptionProperties;

        DefaultGraphQLSubscriptionsSchemaConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public EngineEventsPredicateFactory engineEventsPredicateFactory(RoutingKeyResolver routingKeyResolver) {
            return new EngineEventsDestinationsPredicateFactory(routingKeyResolver);
        }

        @Bean
        @ConditionalOnMissingBean
        public EngineEventsPublisherFactory engineEventPublisherFactory(EngineEventsPredicateFactory engineEventsPredicateFactory, Flux<Message<List<EngineEvent>>> engineEventsFlux) {
            return new EngineEventsFluxPublisherFactory(engineEventsFlux, engineEventsPredicateFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        public EngineEventsPublisherDataFetcher engineEventPublisherDataFetcher(EngineEventsPublisherFactory engineEventPublisherFactory) {
            return new EngineEventsPublisherDataFetcher(engineEventPublisherFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphQLSubscriptionSchemaBuilder graphQLSubscriptionSchemaBuilder(EngineEventsPublisherDataFetcher engineEventPublisherDataFetcher) {
            GraphQLSubscriptionSchemaBuilder schemaBuilder = new GraphQLSubscriptionSchemaBuilder(this.subscriptionProperties.getGraphqls());
            schemaBuilder.withSubscription(this.subscriptionProperties.getSubscriptionFieldName(), engineEventPublisherDataFetcher);
            return schemaBuilder;
        }
    }
}

