/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.activiti.cloud.services.notifications.graphql.events.model.EngineEvent;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsPredicateFactory;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.EngineEventsPublisherFactory;
import org.reactivestreams.Publisher;
import org.springframework.messaging.Message;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.util.Logger;
import reactor.util.Loggers;

public class EngineEventsFluxPublisherFactory
implements EngineEventsPublisherFactory {
    private static Logger logger = Loggers.getLogger(EngineEventsFluxPublisherFactory.class);
    private final Flux<Message<List<EngineEvent>>> engineEventsFlux;
    private final EngineEventsPredicateFactory predicateFactory;

    public EngineEventsFluxPublisherFactory(Flux<Message<List<EngineEvent>>> engineEventsFlux, EngineEventsPredicateFactory predicateFactory) {
        this.engineEventsFlux = engineEventsFlux;
        this.predicateFactory = predicateFactory;
    }

    @Override
    public Flux<List<EngineEvent>> getPublisher(DataFetchingEnvironment environment) {
        Predicate<? super EngineEvent> predicate = this.predicateFactory.getPredicate(environment);
        return Flux.from((Publisher)this.engineEventsFlux.log(logger, Level.CONFIG, true, new SignalType[0]).flatMapSequential(message -> Flux.fromIterable((Iterable)((Iterable)message.getPayload())).filter(predicate).collectList().filter(list -> !list.isEmpty())));
    }
}

