/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher;

import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.activiti.cloud.services.notifications.graphql.subscriptions.datafetcher.DataFetcherDestinationResolver;

public abstract class AbstractDestinationResolver
implements DataFetcherDestinationResolver {
    protected abstract String any();

    protected abstract String wildcard();

    protected abstract String path();

    @Override
    public List<String> resolveDestinations(DataFetchingEnvironment environment) {
        String fieldName = this.resolveFieldName(environment);
        String[] argumentNames = this.resolveArgumentNames(environment);
        ArrayList<String> destinations = new ArrayList<String>();
        if (environment.getArguments().size() > 0) {
            List arguments = Stream.of(argumentNames).map(name -> this.resolveArgument(environment, (String)name)).collect(Collectors.toList());
            AbstractDestinationResolver.crossJoin(arguments).stream().map(list -> list.stream().collect(Collectors.joining(this.path()))).forEach(pattern -> destinations.add(fieldName + this.path() + pattern));
        } else {
            destinations.add(fieldName + this.path() + this.any());
        }
        return destinations;
    }

    protected String resolveFieldName(DataFetchingEnvironment environment) {
        return ((Field)environment.getFields().iterator().next()).getName();
    }

    protected String[] resolveArgumentNames(DataFetchingEnvironment environment) {
        return (String[])environment.getFieldDefinition().getArguments().stream().map(arg -> arg.getName()).toArray(String[]::new);
    }

    private List<String> resolveArgument(DataFetchingEnvironment environment, String argumentName) {
        ArrayList<String> value = new ArrayList<String>();
        Object argument = environment.getArgument(argumentName);
        if (argument instanceof List) {
            value.addAll((Collection)environment.getArgument(argumentName));
        } else if (argument != null) {
            value.add(argument.toString());
        } else {
            value.add(this.wildcard());
        }
        return value;
    }

    public static <T> List<List<T>> crossJoin(List<List<T>> factors) {
        return new CartesianProduct<T>(factors).stream().collect(Collectors.toList());
    }

    public static List<List<String>> zip(List<String> list1, List<String> list2) {
        return AbstractDestinationResolver.crossJoin(Arrays.asList(list1, list2));
    }

    static class CartesianProduct<T>
    implements Iterable<List<T>> {
        private final Iterable<? extends Iterable<T>> factors;

        public CartesianProduct(Iterable<? extends Iterable<T>> factors) {
            this.factors = factors;
        }

        @Override
        public Iterator<List<T>> iterator() {
            return new CartesianProductIterator(this.factors);
        }

        public Stream<List<T>> stream() {
            return StreamSupport.stream(new CartesianProduct<T>(this.factors).spliterator(), false);
        }
    }

    static class CartesianProductIterator<T>
    implements Iterator<List<T>> {
        private final List<Iterable<T>> factors;
        private final Stack<Iterator<T>> iterators;
        private final Stack<T> current;
        private List<T> next;
        private int index = 0;

        public CartesianProductIterator(Iterable<? extends Iterable<T>> factors) {
            this.factors = StreamSupport.stream(factors.spliterator(), false).collect(Collectors.toList());
            if (this.factors.size() == 0) {
                this.index = -1;
            }
            this.iterators = new Stack();
            this.iterators.add(this.factors.get(0).iterator());
            this.current = new Stack();
            this.computeNext();
        }

        private void computeNext() {
            while (true) {
                if (((Iterator)this.iterators.get(this.index)).hasNext()) {
                    this.current.add(((Iterator)this.iterators.get(this.index)).next());
                    if (this.index == this.factors.size() - 1) {
                        this.next = new ArrayList<T>(this.current);
                        this.current.pop();
                        return;
                    }
                    ++this.index;
                    this.iterators.add(this.factors.get(this.index).iterator());
                    continue;
                }
                --this.index;
                if (this.index < 0) {
                    return;
                }
                this.iterators.pop();
                this.current.pop();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null && this.index >= 0) {
                this.computeNext();
            }
            return this.next != null;
        }

        @Override
        public List<T> next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            List<T> result = this.next;
            this.next = null;
            return result;
        }
    }
}

