/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.subscriptions;

import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import com.introproventures.graphql.jpa.query.schema.JavaScalarsWiringPostProcessor;
import graphql.scalars.ExtendedScalars;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import org.springframework.core.io.DefaultResourceLoader;

public class GraphQLSubscriptionSchemaBuilder {
    private GraphQLSchema graphQLSchema = null;
    private final TypeDefinitionRegistry typeRegistry;
    private final RuntimeWiring.Builder wiring;

    public GraphQLSubscriptionSchemaBuilder(String schemaFileName) {
        Reader streamReader;
        try {
            streamReader = this.loadSchemaFile(schemaFileName);
        }
        catch (IOException cause) {
            throw new RuntimeException(cause);
        }
        this.typeRegistry = new SchemaParser().parse(streamReader);
        this.wiring = RuntimeWiring.newRuntimeWiring().scalar(GraphQLScalarType.newScalar().name("ObjectScalar").description("An object scalar").coercing((Coercing)new JavaScalars.GraphQLObjectCoercing()).build()).scalar(ExtendedScalars.GraphQLLong);
    }

    private GraphQLSchema buildSchema() {
        return new JavaScalarsWiringPostProcessor().process(new SchemaGenerator().makeExecutableSchema(this.typeRegistry, this.wiring.build()));
    }

    public TypeRuntimeWiring.Builder withTypeWiring(String typeName) {
        TypeRuntimeWiring.Builder builder = TypeRuntimeWiring.newTypeWiring((String)typeName);
        this.wiring.type(builder);
        return builder;
    }

    public TypeRuntimeWiring.Builder withSubscription(String fieldName, DataFetcher<?> dataFetcher) {
        TypeRuntimeWiring.Builder builder = TypeRuntimeWiring.newTypeWiring((String)"Subscription");
        this.wiring.type(builder.dataFetcher(fieldName, dataFetcher));
        return builder;
    }

    public GraphQLSchema getGraphQLSchema() {
        return Optional.ofNullable(this.graphQLSchema).orElseGet(this::buildSchema);
    }

    protected Reader loadSchemaFile(String name) throws IOException {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        InputStream stream = resourceLoader.getResource(name).getInputStream();
        return new InputStreamReader(stream);
    }
}

