/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.graphql.autoconfigure;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.introproventures.graphql.jpa.query.schema.GraphQLExecutor;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaExecutor;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import org.activiti.cloud.services.graphql.autoconfigure.ActivitiGraphQLWebProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@AutoConfiguration
@ConditionalOnClass(value={GraphQL.class})
@ConditionalOnProperty(name={"spring.activiti.cloud.services.query.graphql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ActivitiGraphQLWebProperties.class})
@PropertySources(value={@PropertySource(value={"classpath:META-INF/graphql.properties"}), @PropertySource(value={"classpath:graphql.properties"}, ignoreResourceNotFound=true)})
public class ActivitiGraphQLAutoConfiguration {

    @Configuration
    public static class DefaultActivitiGraphQLJpaConfiguration {
        @Autowired
        public void configureObjectMapper(ObjectMapper objectMapper) {
            objectMapper.configOverride(Map.class).setInclude(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.ALWAYS, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        }

        @Bean
        @ConditionalOnMissingBean(value={GraphQLExecutor.class})
        public GraphQLExecutor graphQLExecutor(GraphQLSchema querySchema) {
            return new GraphQLJpaExecutor(querySchema);
        }
    }
}

