/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Subgraph;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.TaskEntity;

public class EntityManagerFinder {
    private static final String VARIABLES = "variables";
    private static final String TASKS = "tasks";
    private static final String ACTIVITIES = "activities";
    private static final String SERVICE_TASKS = "serviceTasks";
    private static final String SEQUENCE_FLOWS = "sequenceFlows";
    private static final String PROCESS_VARIABLES = "processVariables";
    private static final String TASK_CANDIDATE_USERS = "taskCandidateUsers";
    private static final String TASK_CANDIDATE_GROUPS = "taskCandidateGroups";
    private final EntityManager entityManager;

    public EntityManagerFinder(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Optional<TaskEntity> findTaskWithVariables(String taskId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(TaskEntity.class);
        entityGraph.addAttributeNodes(new String[]{VARIABLES});
        return Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)taskId, Map.of("jakarta.persistence.loadgraph", entityGraph)));
    }

    public Set<TaskEntity> findTasksWithProcessVariables(String processInstanceId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(ProcessInstanceEntity.class);
        entityGraph.addAttributeNodes(new String[]{TASKS});
        Subgraph taskEntitySubgraph = entityGraph.addSubgraph(TASKS);
        taskEntitySubgraph.addAttributeNodes(new String[]{PROCESS_VARIABLES});
        return ((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId, Map.of("jakarta.persistence.loadgraph", entityGraph))).getTasks();
    }

    public Optional<TaskEntity> findTaskWithCandidateUsers(String taskId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(TaskEntity.class);
        entityGraph.addAttributeNodes(new String[]{TASK_CANDIDATE_USERS});
        return Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)taskId, Map.of("jakarta.persistence.loadgraph", entityGraph)));
    }

    public Optional<TaskEntity> findTaskWithCandidateGroups(String taskId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(TaskEntity.class);
        entityGraph.addAttributeNodes(new String[]{TASK_CANDIDATE_GROUPS});
        return Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)taskId, Map.of("jakarta.persistence.loadgraph", entityGraph)));
    }

    public Optional<ProcessInstanceEntity> findProcessInstanceWithVariables(String processInstanceId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(ProcessInstanceEntity.class);
        entityGraph.addAttributeNodes(new String[]{VARIABLES});
        return Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId, Map.of("jakarta.persistence.loadgraph", entityGraph)));
    }

    public Optional<ProcessInstanceEntity> findProcessInstanceWithRelatedEntities(String processInstanceId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(ProcessInstanceEntity.class);
        entityGraph.addAttributeNodes(new String[]{VARIABLES, TASKS, ACTIVITIES, SERVICE_TASKS, SEQUENCE_FLOWS});
        return Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId, Map.of("jakarta.persistence.loadgraph", entityGraph)));
    }

    public Optional<ProcessInstanceEntity> findProcessInstanceWithSequenceFlows(String processInstanceId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(ProcessInstanceEntity.class);
        entityGraph.addAttributeNodes(new String[]{SEQUENCE_FLOWS});
        return Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId, Map.of("jakarta.persistence.loadgraph", entityGraph)));
    }

    public Optional<ProcessInstanceEntity> findProcessInstanceWithTasks(String processInstanceId) {
        EntityGraph entityGraph = this.entityManager.createEntityGraph(ProcessInstanceEntity.class);
        entityGraph.addAttributeNodes(new String[]{TASKS});
        return Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId, Map.of("jakarta.persistence.loadgraph", entityGraph)));
    }
}

