/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import org.activiti.api.model.shared.event.VariableEvent;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableCreatedEvent;
import org.activiti.cloud.services.query.events.handlers.ProcessVariableCreatedEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.events.handlers.TaskVariableCreatedEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableCreatedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableCreatedEventHandler.class);
    private final ProcessVariableCreatedEventHandler processVariableCreatedEventHandler;
    private final TaskVariableCreatedEventHandler taskVariableCreatedEventHandler;

    public VariableCreatedEventHandler(TaskVariableCreatedEventHandler taskVariableCreatedEventHandler, ProcessVariableCreatedEventHandler processVariableCreatedEventHandler) {
        this.taskVariableCreatedEventHandler = taskVariableCreatedEventHandler;
        this.processVariableCreatedEventHandler = processVariableCreatedEventHandler;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudVariableCreatedEvent variableCreatedEvent = (CloudVariableCreatedEvent)event;
        LOGGER.debug("Handling variableEntity created event: " + ((VariableInstance)variableCreatedEvent.getEntity()).getName());
        try {
            if (((VariableInstance)variableCreatedEvent.getEntity()).isTaskVariable()) {
                this.taskVariableCreatedEventHandler.handle(variableCreatedEvent);
            } else {
                this.processVariableCreatedEventHandler.handle(variableCreatedEvent);
            }
        }
        catch (Exception cause) {
            LOGGER.error("Error handling VariableCreatedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return VariableEvent.VariableEvents.VARIABLE_CREATED.name();
    }
}

