/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessUpdatedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QueryException;

public class ProcessUpdatedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public ProcessUpdatedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessUpdatedEvent updatedEvent = (CloudProcessUpdatedEvent)event;
        ProcessInstance eventProcessInstance = (ProcessInstance)updatedEvent.getEntity();
        ProcessInstanceEntity processInstanceEntity = Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)eventProcessInstance.getId())).orElseThrow(() -> new QueryException("Unable to find process instance with the given id: " + eventProcessInstance.getId()));
        processInstanceEntity.setBusinessKey(eventProcessInstance.getBusinessKey());
        processInstanceEntity.setName(eventProcessInstance.getName());
        processInstanceEntity.setLastModified(new Date(updatedEvent.getTimestamp()));
        this.entityManager.persist((Object)processInstanceEntity);
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_UPDATED.name();
    }
}

