/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudVariableDeletedEvent;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessVariableDeletedEventHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessVariableDeletedEventHandler.class);
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public ProcessVariableDeletedEventHandler(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    public void handle(CloudVariableDeletedEvent event) {
        String variableName = ((VariableInstance)event.getEntity()).getName();
        String processInstanceId = ((VariableInstance)event.getEntity()).getProcessInstanceId();
        Optional<ProcessInstanceEntity> findResult = this.entityManagerFinder.findProcessInstanceWithVariables(processInstanceId);
        if (findResult.isPresent() && !findResult.get().isInFinalState()) {
            try {
                ProcessInstanceEntity processInstanceEntity = findResult.get();
                processInstanceEntity.getVariable(variableName).ifPresentOrElse(variableEntity -> {
                    processInstanceEntity.getVariables().remove(variableEntity);
                    this.entityManager.remove(variableEntity);
                }, () -> LOGGER.warn("Unable to find variableEntity with name '" + variableName + "' for process instance '" + processInstanceId + "'"));
            }
            catch (Exception cause) {
                LOGGER.error("Error handling ProcessVariableDeletedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
            }
        }
    }
}

