/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessDeletedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.BPMNActivityEntity;
import org.activiti.cloud.services.query.model.BPMNSequenceFlowEntity;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;

public class ProcessDeletedEventHandler
implements QueryEventHandler {
    protected final String INVALID_PROCESS_INSTANCE_STATE = "Process Instance %s is not in a valid state: %s. Only process instances in status COMPLETED or CANCELLED can be deleted.";
    private Set<ProcessInstance.ProcessInstanceStatus> ALLOWED_STATUS = Set.of(ProcessInstance.ProcessInstanceStatus.CANCELLED, ProcessInstance.ProcessInstanceStatus.COMPLETED);
    private final EntityManager entityManager;

    public ProcessDeletedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessDeletedEvent deletedEvent = (CloudProcessDeletedEvent)event;
        String eventProcessInstanceId = ((ProcessInstance)deletedEvent.getEntity()).getId();
        ProcessInstanceEntity processInstanceEntity = Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)eventProcessInstanceId)).orElseThrow(() -> new QueryException("Unable to find process instance with the given id: " + eventProcessInstanceId));
        if (!this.ALLOWED_STATUS.contains(processInstanceEntity.getStatus())) {
            throw new IllegalStateException(String.format("Process Instance %s is not in a valid state: %s. Only process instances in status COMPLETED or CANCELLED can be deleted.", processInstanceEntity.getId(), processInstanceEntity.getStatus().name()));
        }
        this.remove(TaskCandidateUserEntity.class, "taskId", TaskEntity.class, "id", "processInstanceId", eventProcessInstanceId);
        this.remove(TaskCandidateGroupEntity.class, "taskId", TaskEntity.class, "id", "processInstanceId", eventProcessInstanceId);
        this.remove(TaskVariableEntity.class, "processInstanceId", eventProcessInstanceId);
        this.remove(TaskEntity.class, "processInstanceId", eventProcessInstanceId);
        this.remove(ProcessVariableEntity.class, "processInstanceId", eventProcessInstanceId);
        this.remove(IntegrationContextEntity.class, "processInstanceId", eventProcessInstanceId);
        this.remove(ServiceTaskEntity.class, "processInstanceId", eventProcessInstanceId);
        this.remove(BPMNActivityEntity.class, "processInstanceId", eventProcessInstanceId);
        this.remove(BPMNSequenceFlowEntity.class, "processInstanceId", eventProcessInstanceId);
        this.remove(ProcessInstanceEntity.class, "id", eventProcessInstanceId);
    }

    <T> void remove(Class<T> entityClass, String attributeName, Object attributeValue) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaDelete delete = criteriaBuilder.createCriteriaDelete(entityClass);
        Root from = delete.from(entityClass);
        delete.where((Expression)criteriaBuilder.equal((Expression)from.get(attributeName), attributeValue));
        this.entityManager.createQuery(delete).executeUpdate();
    }

    <P, T> void remove(Class<T> entityClass, String attributeName, Class<P> parentClass, String parentIdAttribute, String parentAttributeName, Object parentAttributeValue) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery parentQuery = criteriaBuilder.createQuery(Object.class);
        Root parentFrom = parentQuery.from(parentClass);
        parentQuery.select((Selection)parentFrom.get(parentIdAttribute));
        parentQuery.where((Expression)criteriaBuilder.equal((Expression)parentFrom.get(parentAttributeName), parentAttributeValue));
        List parentIds = this.entityManager.createQuery(parentQuery).getResultList();
        if (!parentIds.isEmpty()) {
            CriteriaDelete delete = criteriaBuilder.createCriteriaDelete(entityClass);
            Root from = delete.from(entityClass);
            delete.where((Expression)from.get(attributeName).in((Collection)parentIds));
            this.entityManager.createQuery(delete).executeUpdate();
        }
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_DELETED.name();
    }
}

