/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.events.TaskRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskSuspendedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;

public class TaskSuspendedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public TaskSuspendedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskSuspendedEvent taskSuspendedEvent = (CloudTaskSuspendedEvent)event;
        Task eventTask = (Task)taskSuspendedEvent.getEntity();
        TaskEntity taskEntity = Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)eventTask.getId())).orElseThrow(() -> new QueryException("Unable to find task with id: " + eventTask.getId()));
        taskEntity.setStatus(Task.TaskStatus.SUSPENDED);
        taskEntity.setLastModified(new Date(taskSuspendedEvent.getTimestamp()));
        this.entityManager.persist((Object)taskEntity);
    }

    @Override
    public String getHandledEvent() {
        return TaskRuntimeEvent.TaskEvents.TASK_SUSPENDED.name();
    }
}

