/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.BPMNSequenceFlow;
import org.activiti.api.process.model.events.SequenceFlowEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudSequenceFlowTakenEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.BPMNSequenceFlowEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMNSequenceFlowTakenEventHandler
implements QueryEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(BPMNSequenceFlowTakenEventHandler.class);
    private final EntityManager entityManager;

    public BPMNSequenceFlowTakenEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudSequenceFlowTakenEvent sequenceFlowTakenEvent = (CloudSequenceFlowTakenEvent)CloudSequenceFlowTakenEvent.class.cast(event);
        String entityId = this.getEntityId(sequenceFlowTakenEvent);
        Optional.ofNullable((BPMNSequenceFlowEntity)this.entityManager.find(BPMNSequenceFlowEntity.class, (Object)entityId)).ifPresentOrElse(sequenceFlowEntity -> logger.warn("Sequence flow '" + sequenceFlowEntity.getElementId() + "' with eventId '" + event.getId() + "' already exists in the process '" + ((BPMNSequenceFlow)sequenceFlowTakenEvent.getEntity()).getProcessInstanceId() + "'!"), () -> {
            BPMNSequenceFlowEntity sequenceFlowTakenEntity = this.createBpmnSequenceFlowEntity(entityId, sequenceFlowTakenEvent);
            this.entityManager.persist((Object)sequenceFlowTakenEntity);
        });
    }

    private BPMNSequenceFlowEntity createBpmnSequenceFlowEntity(String entityId, CloudSequenceFlowTakenEvent event) {
        BPMNSequenceFlow bpmnSequenceFlow = (BPMNSequenceFlow)event.getEntity();
        BPMNSequenceFlowEntity bpmnSequenceFlowEntity = new BPMNSequenceFlowEntity(event.getServiceName(), event.getServiceFullName(), event.getServiceVersion(), event.getAppName(), event.getAppVersion());
        bpmnSequenceFlowEntity.setId(entityId);
        bpmnSequenceFlowEntity.setElementId(bpmnSequenceFlow.getElementId());
        bpmnSequenceFlowEntity.setProcessDefinitionId(bpmnSequenceFlow.getProcessDefinitionId());
        bpmnSequenceFlowEntity.setProcessInstanceId(bpmnSequenceFlow.getProcessInstanceId());
        bpmnSequenceFlowEntity.setDate(new Date(event.getTimestamp()));
        bpmnSequenceFlowEntity.setSourceActivityElementId(bpmnSequenceFlow.getSourceActivityElementId());
        bpmnSequenceFlowEntity.setSourceActivityType(bpmnSequenceFlow.getSourceActivityType());
        bpmnSequenceFlowEntity.setSourceActivityName(bpmnSequenceFlow.getSourceActivityName());
        bpmnSequenceFlowEntity.setTargetActivityElementId(bpmnSequenceFlow.getTargetActivityElementId());
        bpmnSequenceFlowEntity.setTargetActivityType(bpmnSequenceFlow.getTargetActivityType());
        bpmnSequenceFlowEntity.setTargetActivityName(bpmnSequenceFlow.getTargetActivityName());
        bpmnSequenceFlowEntity.setProcessDefinitionKey(event.getProcessDefinitionKey());
        bpmnSequenceFlowEntity.setProcessDefinitionVersion(event.getProcessDefinitionVersion());
        bpmnSequenceFlowEntity.setBusinessKey(event.getBusinessKey());
        bpmnSequenceFlowEntity.setEventId(event.getId());
        return bpmnSequenceFlowEntity;
    }

    private String getEntityId(CloudSequenceFlowTakenEvent event) {
        return ((BPMNSequenceFlow)event.getEntity()).getProcessInstanceId() + ":" + ((BPMNSequenceFlow)event.getEntity()).getElementId() + ":" + event.getId();
    }

    @Override
    public String getHandledEvent() {
        return SequenceFlowEvent.SequenceFlowEvents.SEQUENCE_FLOW_TAKEN.name();
    }
}

