/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import org.activiti.api.process.model.events.BPMNActivityEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.CloudBPMNActivity;
import org.activiti.cloud.api.process.model.events.CloudBPMNActivityCancelledEvent;
import org.activiti.cloud.services.query.events.handlers.BaseBPMNActivityEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.BaseBPMNActivityEntity;

public class BPMNActivityCancelledEventHandler
extends BaseBPMNActivityEventHandler
implements QueryEventHandler {
    public BPMNActivityCancelledEventHandler(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudBPMNActivityCancelledEvent activityEvent = (CloudBPMNActivityCancelledEvent)CloudBPMNActivityCancelledEvent.class.cast(event);
        BaseBPMNActivityEntity bpmnActivityEntity = this.findOrCreateBPMNActivityEntity(event);
        bpmnActivityEntity.setCancelledDate(new Date(activityEvent.getTimestamp()));
        bpmnActivityEntity.setStatus(CloudBPMNActivity.BPMNActivityStatus.CANCELLED);
        this.entityManager.persist((Object)bpmnActivityEntity);
    }

    @Override
    public String getHandledEvent() {
        return BPMNActivityEvent.ActivityEvents.ACTIVITY_CANCELLED.name();
    }
}

