/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.task.model.TaskCandidateGroup;
import org.activiti.api.task.model.events.TaskCandidateGroupEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateGroupRemovedEvent;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.TaskCandidateGroupId;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCandidateGroupRemovedEventHandler
implements QueryEventHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskCandidateGroupRemovedEventHandler.class);
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public TaskCandidateGroupRemovedEventHandler(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskCandidateGroupRemovedEvent taskCandidateGroupRemovedEvent = (CloudTaskCandidateGroupRemovedEvent)event;
        TaskCandidateGroup taskCandidateGroup = (TaskCandidateGroup)taskCandidateGroupRemovedEvent.getEntity();
        Optional<TaskEntity> findResult = this.entityManagerFinder.findTaskWithCandidateGroups(taskCandidateGroup.getTaskId());
        if (findResult.isPresent() && !findResult.get().isInFinalState()) {
            try {
                TaskCandidateGroupId id = new TaskCandidateGroupId(taskCandidateGroup.getTaskId(), taskCandidateGroup.getGroupId());
                Optional.ofNullable((TaskCandidateGroupEntity)this.entityManager.find(TaskCandidateGroupEntity.class, (Object)id)).ifPresent(arg_0 -> ((EntityManager)this.entityManager).remove(arg_0));
            }
            catch (Exception cause) {
                LOGGER.debug("Error handling TaskCandidateGroupRemovedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
            }
        }
    }

    @Override
    public String getHandledEvent() {
        return TaskCandidateGroupEvent.TaskCandidateGroupEvents.TASK_CANDIDATE_GROUP_REMOVED.name();
    }
}

