/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.events.TaskRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskUpdatedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;

public class TaskUpdatedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public TaskUpdatedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskUpdatedEvent taskUpdatedEvent = (CloudTaskUpdatedEvent)event;
        Task eventTask = (Task)taskUpdatedEvent.getEntity();
        TaskEntity queryTaskEntity = Optional.ofNullable((TaskEntity)this.entityManager.find(TaskEntity.class, (Object)eventTask.getId())).orElseThrow(() -> new QueryException("Unable to find task with id: " + eventTask.getId()));
        queryTaskEntity.setName(eventTask.getName());
        queryTaskEntity.setDescription(eventTask.getDescription());
        queryTaskEntity.setPriority(eventTask.getPriority());
        queryTaskEntity.setDueDate(eventTask.getDueDate());
        queryTaskEntity.setFormKey(eventTask.getFormKey());
        queryTaskEntity.setParentTaskId(eventTask.getParentTaskId());
        queryTaskEntity.setLastModified(new Date(taskUpdatedEvent.getTimestamp()));
        queryTaskEntity.setStatus(eventTask.getStatus());
        this.entityManager.persist((Object)queryTaskEntity);
    }

    @Override
    public String getHandledEvent() {
        return TaskRuntimeEvent.TaskEvents.TASK_UPDATED.name();
    }
}

