/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessCancelledEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessCancelledEventHandler
implements QueryEventHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessCancelledEventHandler.class);
    private final EntityManager entityManager;

    public ProcessCancelledEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessCancelledEvent cancelledEvent = (CloudProcessCancelledEvent)event;
        LOGGER.debug("Handling cancel of process Instance " + ((ProcessInstance)cancelledEvent.getEntity()).getId());
        ProcessInstanceEntity processInstanceEntity = Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)((ProcessInstance)cancelledEvent.getEntity()).getId())).orElseThrow(() -> new QueryException("Unable to find process instance with the given id: " + ((ProcessInstance)cancelledEvent.getEntity()).getId()));
        processInstanceEntity.setStatus(ProcessInstance.ProcessInstanceStatus.CANCELLED);
        processInstanceEntity.setLastModified(new Date(cancelledEvent.getTimestamp()));
        this.entityManager.persist((Object)processInstanceEntity);
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_CANCELLED.name();
    }
}

