/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.QueryException;

public class ProcessVariableUpdater {
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public ProcessVariableUpdater(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    public void update(ProcessVariableEntity updatedVariableEntity, String notFoundMessage) {
        String processInstanceId = updatedVariableEntity.getProcessInstanceId();
        ProcessInstanceEntity processInstanceEntity = this.entityManagerFinder.findProcessInstanceWithVariables(processInstanceId).orElseThrow(() -> new QueryException("Process instance id " + processInstanceId + " not found!"));
        processInstanceEntity.getVariable(updatedVariableEntity.getName()).ifPresentOrElse(variableEntity -> {
            variableEntity.setLastUpdatedTime(updatedVariableEntity.getLastUpdatedTime());
            variableEntity.setType(updatedVariableEntity.getType());
            variableEntity.setValue(updatedVariableEntity.getValue());
            this.entityManager.persist(variableEntity);
        }, () -> {
            throw new QueryException(notFoundMessage);
        });
    }
}

