/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.process.model.Deployment;
import org.activiti.api.process.model.events.ApplicationEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudApplicationDeployedEvent;
import org.activiti.cloud.services.query.app.repository.ApplicationRepository;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ApplicationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDeployedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDeployedEventHandler.class);
    private final EntityManager entityManager;
    private final ApplicationRepository applicationRepository;

    public ApplicationDeployedEventHandler(EntityManager entityManager, ApplicationRepository applicationRepository) {
        this.entityManager = entityManager;
        this.applicationRepository = applicationRepository;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudApplicationDeployedEvent applicationDeployedEvent = (CloudApplicationDeployedEvent)event;
        Deployment deployment = (Deployment)applicationDeployedEvent.getEntity();
        LOGGER.debug("Handling application deployed event for " + deployment.getId());
        ApplicationEntity application = new ApplicationEntity(deployment.getId(), applicationDeployedEvent.getAppName(), deployment.getVersion().toString());
        if (this.applicationRepository.existsByNameAndVersion(application.getName(), application.getVersion())) {
            LOGGER.debug("Application {} with version {} already exists!", (Object)application.getName(), (Object)application.getVersion());
            return;
        }
        this.entityManager.persist((Object)application);
    }

    @Override
    public String getHandledEvent() {
        return ApplicationEvent.ApplicationEvents.APPLICATION_DEPLOYED.name();
    }
}

