/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.api.model.shared.event.RuntimeEvent;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableCreatedEventImpl;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableDeletedEventImpl;
import org.activiti.cloud.api.model.shared.impl.events.CloudVariableUpdatedEventImpl;
import org.activiti.cloud.api.process.model.events.CloudBPMNActivityEvent;
import org.activiti.cloud.api.process.model.impl.events.CloudBPMNActivityCancelledEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudBPMNActivityCompletedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudBPMNActivityStartedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudBPMNSignalReceivedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIntegrationErrorReceivedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIntegrationRequestedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIntegrationResultReceivedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCancelledEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCandidateStarterGroupAddedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCandidateStarterGroupRemovedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCandidateStarterUserAddedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCandidateStarterUserRemovedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCompletedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessCreatedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessDeletedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessStartedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessSuspendedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudProcessUpdatedEventImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudSequenceFlowTakenEventImpl;
import org.activiti.cloud.api.task.model.events.CloudTaskRuntimeEvent;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskActivatedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskAssignedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCancelledEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateGroupAddedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateGroupRemovedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateUserAddedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCandidateUserRemovedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCompletedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCreatedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskSuspendedEventImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskUpdatedEventImpl;
import org.activiti.cloud.services.query.model.BPMNActivityEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEventHandlerContextOptimizer {
    public static final String VARIABLES = "variables";
    public static final String TASKS = "tasks";
    public static final String ACTIVITIES = "activities";
    public static final String SERVICE_TASKS = "serviceTasks";
    public static final String SEQUENCE_FLOWS = "sequenceFlows";
    private static Logger LOGGER = LoggerFactory.getLogger(QueryEventHandlerContextOptimizer.class);
    private Map<Class<? extends CloudRuntimeEvent>, Integer> order = Map.ofEntries(Map.entry(CloudRuntimeEvent.class, 0), Map.entry(CloudProcessCreatedEventImpl.class, 0), Map.entry(CloudProcessStartedEventImpl.class, 1), Map.entry(CloudProcessUpdatedEventImpl.class, 1), Map.entry(CloudProcessSuspendedEventImpl.class, 1), Map.entry(CloudSequenceFlowTakenEventImpl.class, 2), Map.entry(CloudBPMNActivityStartedEventImpl.class, 3), Map.entry(CloudIntegrationRequestedEventImpl.class, 4), Map.entry(CloudBPMNSignalReceivedEventImpl.class, 5), Map.entry(CloudBPMNActivityCompletedEventImpl.class, 6), Map.entry(CloudBPMNActivityCancelledEventImpl.class, 6), Map.entry(CloudIntegrationResultReceivedEventImpl.class, 7), Map.entry(CloudIntegrationErrorReceivedEventImpl.class, 7), Map.entry(CloudTaskCreatedEventImpl.class, 8), Map.entry(CloudTaskCandidateUserAddedEventImpl.class, 9), Map.entry(CloudTaskCandidateGroupAddedEventImpl.class, 9), Map.entry(CloudVariableCreatedEventImpl.class, 10), Map.entry(CloudVariableUpdatedEventImpl.class, 11), Map.entry(CloudVariableDeletedEventImpl.class, 12), Map.entry(CloudTaskActivatedEventImpl.class, 13), Map.entry(CloudTaskSuspendedEventImpl.class, 13), Map.entry(CloudTaskAssignedEventImpl.class, 13), Map.entry(CloudTaskUpdatedEventImpl.class, 13), Map.entry(CloudTaskCompletedEventImpl.class, 14), Map.entry(CloudTaskCancelledEventImpl.class, 14), Map.entry(CloudTaskCandidateUserRemovedEventImpl.class, 15), Map.entry(CloudTaskCandidateGroupRemovedEventImpl.class, 15), Map.entry(CloudProcessCompletedEventImpl.class, 16), Map.entry(CloudProcessCancelledEventImpl.class, 16), Map.entry(CloudProcessCandidateStarterUserAddedEventImpl.class, 17), Map.entry(CloudProcessCandidateStarterGroupAddedEventImpl.class, 17), Map.entry(CloudProcessCandidateStarterUserRemovedEventImpl.class, 18), Map.entry(CloudProcessCandidateStarterGroupRemovedEventImpl.class, 18), Map.entry(CloudProcessDeletedEventImpl.class, 19));
    private Comparator<CloudRuntimeEvent<?, ?>> byTimestamp = Comparator.comparingLong(RuntimeEvent::getTimestamp);
    private Comparator<CloudRuntimeEvent<?, ?>> byEventClass = Comparator.comparing(event -> Optional.ofNullable(this.order.get(event.getClass())).orElseGet(() -> this.order.get(CloudRuntimeEvent.class)));
    private final EntityManager entityManager;

    public QueryEventHandlerContextOptimizer(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public List<CloudRuntimeEvent<?, ?>> optimize(List<CloudRuntimeEvent<?, ?>> events) {
        this.resolveProcessInstanceId(events).ifPresent(processInstanceId -> {
            LOGGER.debug("Building entity fetch graph for root process instance: {}", processInstanceId);
            EntityGraph entityGraph = this.entityManager.createEntityGraph(ProcessInstanceEntity.class);
            CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(ProcessInstanceEntity.class);
            Root fromProcessInstance = criteriaQuery.from(ProcessInstanceEntity.class);
            Predicate whereProcessInstance = criteriaBuilder.equal((Expression)fromProcessInstance.get("id"), processInstanceId);
            criteriaQuery.select((Selection)fromProcessInstance).where((Expression)whereProcessInstance);
            this.findRuntimeEvents(events, CloudVariableEvent.class, entity -> true, VariableInstance::getName).ifPresent(variableNames -> this.fetch((Root)fromProcessInstance, (EntityGraph)entityGraph, VARIABLES, "name", (List)variableNames));
            this.findRuntimeEvents(events, CloudTaskRuntimeEvent.class, entity -> true, Task::getId).ifPresent(taskIds -> this.fetch((Root)fromProcessInstance, (EntityGraph)entityGraph, TASKS, "id", (List)taskIds));
            this.findRuntimeEvents(events, CloudBPMNActivityEvent.class, entity -> true, BPMNActivityEntity.IdBuilderHelper::from).ifPresent(activityIds -> this.fetch((Root)fromProcessInstance, (EntityGraph)entityGraph, ACTIVITIES, "id", (List)activityIds));
            this.findRuntimeEvents(events, CloudBPMNActivityEvent.class, entity -> SERVICE_TASKS.equals(entity.getActivityType()), BPMNActivityEntity.IdBuilderHelper::from).ifPresent(serviceTaskIds -> this.fetch((Root)fromProcessInstance, (EntityGraph)entityGraph, SERVICE_TASKS, "id", (List)serviceTaskIds));
            this.entityManager.createQuery(criteriaQuery).setHint("jakarta.persistence.loadgraph", (Object)entityGraph).getResultList().stream().findFirst().ifPresent(rootProcessInstance -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Fetched entity graph attributes {} for process instance: {}", entityGraph.getAttributeNodes().stream().map(AttributeNode::getAttributeName).collect(Collectors.toList()), processInstanceId);
                }
            });
        });
        return events.stream().sorted(this.byEventClass.thenComparing(this.byTimestamp)).collect(Collectors.toList());
    }

    protected Optional<String> resolveProcessInstanceId(List<CloudRuntimeEvent<?, ?>> events) {
        return events.stream().map(RuntimeEvent::getProcessInstanceId).filter(Objects::nonNull).findFirst();
    }

    protected Optional<CloudRuntimeEvent<?, ?>> findRuntimeEvent(List<CloudRuntimeEvent<?, ?>> events, Class<? extends CloudRuntimeEvent<?, ?>> runtimeEventClass) {
        return events.stream().filter(runtimeEventClass::isInstance).findFirst();
    }

    protected <T, R> Optional<List<R>> findRuntimeEvents(List<CloudRuntimeEvent<?, ?>> events, Class<? extends CloudRuntimeEvent<T, ?>> runtimeEventClass, java.util.function.Predicate<T> predicate, Function<T, R> mapper) {
        return Optional.of(events.stream().filter(runtimeEventClass::isInstance).map(runtimeEventClass::cast).map(RuntimeEvent::getEntity).filter(predicate).map(mapper).distinct().toList()).filter(java.util.function.Predicate.not(List::isEmpty));
    }

    protected <T, R> void fetch(Root<T> from, EntityGraph<T> entityGraph, String association, String attribute, List<R> ids) {
        entityGraph.addAttributeNodes(new String[]{association});
        Join join = (Join)from.fetch(association);
        join.on((Expression)join.get(attribute).in(ids));
    }
}

