/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import java.util.Date;
import org.activiti.api.model.shared.event.VariableEvent;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableUpdatedEvent;
import org.activiti.cloud.services.query.events.handlers.ProcessVariableUpdateEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.events.handlers.TaskVariableUpdatedEventHandler;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableUpdatedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableUpdatedEventHandler.class);
    private ProcessVariableUpdateEventHandler processVariableUpdateEventHandler;
    private TaskVariableUpdatedEventHandler taskVariableUpdatedEventHandler;

    public VariableUpdatedEventHandler(ProcessVariableUpdateEventHandler processVariableUpdateEventHandler, TaskVariableUpdatedEventHandler taskVariableUpdatedEventHandler) {
        this.processVariableUpdateEventHandler = processVariableUpdateEventHandler;
        this.taskVariableUpdatedEventHandler = taskVariableUpdatedEventHandler;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudVariableUpdatedEvent variableUpdatedEvent = (CloudVariableUpdatedEvent)event;
        try {
            if (((VariableInstance)variableUpdatedEvent.getEntity()).isTaskVariable()) {
                TaskVariableEntity variableEntity = new TaskVariableEntity(null, ((VariableInstance)variableUpdatedEvent.getEntity()).getType(), ((VariableInstance)variableUpdatedEvent.getEntity()).getName(), ((VariableInstance)variableUpdatedEvent.getEntity()).getProcessInstanceId(), variableUpdatedEvent.getServiceName(), variableUpdatedEvent.getServiceFullName(), variableUpdatedEvent.getServiceVersion(), variableUpdatedEvent.getAppName(), variableUpdatedEvent.getAppVersion(), ((VariableInstance)variableUpdatedEvent.getEntity()).getTaskId(), new Date(variableUpdatedEvent.getTimestamp()), new Date(variableUpdatedEvent.getTimestamp()), null);
                variableEntity.setValue(((VariableInstance)variableUpdatedEvent.getEntity()).getValue());
                this.taskVariableUpdatedEventHandler.handle(variableEntity);
            } else {
                ProcessVariableEntity variableEntity = new ProcessVariableEntity((CloudVariableEvent)variableUpdatedEvent);
                variableEntity.setValue(((VariableInstance)variableUpdatedEvent.getEntity()).getValue());
                this.processVariableUpdateEventHandler.handle(variableEntity);
            }
        }
        catch (Exception cause) {
            LOGGER.debug("Error handling VariableUpdatedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return VariableEvent.VariableEvents.VARIABLE_UPDATED.name();
    }
}

