/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.task.model.TaskCandidateGroup;
import org.activiti.api.task.model.events.TaskCandidateGroupEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateGroupAddedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.TaskCandidateGroupId;

public class TaskCandidateGroupAddedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public TaskCandidateGroupAddedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskCandidateGroupAddedEvent taskCandidateGroupAddedEvent = (CloudTaskCandidateGroupAddedEvent)event;
        TaskCandidateGroup taskCandidateGroup = (TaskCandidateGroup)taskCandidateGroupAddedEvent.getEntity();
        TaskCandidateGroupEntity taskCandidateGroupEntity = new TaskCandidateGroupEntity(taskCandidateGroup.getTaskId(), taskCandidateGroup.getGroupId());
        try {
            if (!this.taskCandidateEntityAlreadyExists(taskCandidateGroupEntity)) {
                this.entityManager.persist((Object)taskCandidateGroupEntity);
            }
        }
        catch (Exception cause) {
            throw new QueryException("Error handling TaskCandidateGroupAddedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return TaskCandidateGroupEvent.TaskCandidateGroupEvents.TASK_CANDIDATE_GROUP_ADDED.name();
    }

    private boolean taskCandidateEntityAlreadyExists(TaskCandidateGroupEntity entity) {
        return this.entityManager.find(TaskCandidateGroupEntity.class, (Object)new TaskCandidateGroupId(entity.getTaskId(), entity.getGroupId())) != null;
    }
}

