/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.task.model.TaskCandidateUser;
import org.activiti.api.task.model.events.TaskCandidateUserEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateUserRemovedEvent;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserId;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCandidateUserRemovedEventHandler
implements QueryEventHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(TaskCandidateUserRemovedEventHandler.class);
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public TaskCandidateUserRemovedEventHandler(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskCandidateUserRemovedEvent taskCandidateUserRemovedEvent = (CloudTaskCandidateUserRemovedEvent)event;
        TaskCandidateUser taskCandidateUser = (TaskCandidateUser)taskCandidateUserRemovedEvent.getEntity();
        Optional<TaskEntity> findResult = this.entityManagerFinder.findTaskWithCandidateUsers(taskCandidateUser.getTaskId());
        if (findResult.isPresent() && !findResult.get().isInFinalState()) {
            try {
                TaskCandidateUserId id = new TaskCandidateUserId(taskCandidateUser.getTaskId(), taskCandidateUser.getUserId());
                Optional.ofNullable((TaskCandidateUserEntity)this.entityManager.find(TaskCandidateUserEntity.class, (Object)id)).ifPresent(arg_0 -> ((EntityManager)this.entityManager).remove(arg_0));
            }
            catch (Exception cause) {
                LOGGER.debug("Error handling TaskCandidateUserRemovedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
            }
        }
    }

    @Override
    public String getHandledEvent() {
        return TaskCandidateUserEvent.TaskCandidateUserEvents.TASK_CANDIDATE_USER_REMOVED.name();
    }
}

