/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.process.model.events.CloudIntegrationEvent;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIntegrationEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseIntegrationEventHandler.class);
    protected final EntityManager entityManager;

    public BaseIntegrationEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected Optional<IntegrationContextEntity> findIntegrationContextEntity(CloudIntegrationEvent event) {
        IntegrationContext integrationContext = (IntegrationContext)event.getEntity();
        IntegrationContextEntity entity = (IntegrationContextEntity)this.entityManager.find(IntegrationContextEntity.class, (Object)integrationContext.getId());
        return Optional.ofNullable(entity);
    }

    protected IntegrationContextEntity createMissingIntegrationContextEntity(CloudIntegrationEvent integrationEvent) {
        IntegrationContext integrationContext = (IntegrationContext)integrationEvent.getEntity();
        IntegrationContextEntity entity = new IntegrationContextEntity(integrationEvent.getServiceName(), integrationEvent.getServiceFullName(), integrationEvent.getServiceVersion(), integrationEvent.getAppName(), integrationEvent.getAppVersion());
        entity.setId(integrationContext.getId());
        entity.setClientId(integrationContext.getClientId());
        entity.setClientName(integrationContext.getClientName());
        entity.setClientType(integrationContext.getClientType());
        entity.setConnectorType(integrationContext.getConnectorType());
        entity.setProcessDefinitionId(integrationContext.getProcessDefinitionId());
        entity.setProcessInstanceId(integrationContext.getProcessInstanceId());
        entity.setRootProcessInstanceId(integrationContext.getRootProcessInstanceId());
        entity.setExecutionId(integrationContext.getExecutionId());
        entity.setProcessDefinitionKey(integrationContext.getProcessDefinitionKey());
        entity.setProcessDefinitionVersion(integrationContext.getProcessDefinitionVersion());
        entity.setBusinessKey(integrationContext.getBusinessKey());
        entity.setInBoundVariables(integrationContext.getInBoundVariables());
        return entity;
    }
}

