/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.process.model.ProcessCandidateStarterGroup;
import org.activiti.api.process.model.events.ProcessCandidateStarterGroupEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessCandidateStarterGroupAddedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessCandidateStarterGroupEntity;
import org.activiti.cloud.services.query.model.ProcessCandidateStarterGroupId;
import org.activiti.cloud.services.query.model.QueryException;

public class ProcessCandidateStarterGroupAddedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public ProcessCandidateStarterGroupAddedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessCandidateStarterGroupAddedEvent processCandidateStarterGroupAddedEvent = (CloudProcessCandidateStarterGroupAddedEvent)event;
        ProcessCandidateStarterGroup processCandidateStarterGroup = (ProcessCandidateStarterGroup)processCandidateStarterGroupAddedEvent.getEntity();
        ProcessCandidateStarterGroupEntity entity = new ProcessCandidateStarterGroupEntity(processCandidateStarterGroup.getProcessDefinitionId(), processCandidateStarterGroup.getGroupId());
        try {
            if (!this.candidateStarterEntityAlreadyExists(entity)) {
                this.entityManager.persist((Object)entity);
            }
        }
        catch (Exception cause) {
            throw new QueryException("Error handling ProcessCandidateStarterGroupAddedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return ProcessCandidateStarterGroupEvent.ProcessCandidateStarterGroupEvents.PROCESS_CANDIDATE_STARTER_GROUP_ADDED.name();
    }

    private boolean candidateStarterEntityAlreadyExists(ProcessCandidateStarterGroupEntity entity) {
        return this.entityManager.find(ProcessCandidateStarterGroupEntity.class, (Object)new ProcessCandidateStarterGroupId(entity.getProcessDefinitionId(), entity.getGroupId())) != null;
    }
}

