/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Set;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudVariableCreatedEvent;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.model.AbstractVariableEntity;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessVariableCreatedEventHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessVariableCreatedEventHandler.class);
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public ProcessVariableCreatedEventHandler(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    public void handle(CloudVariableCreatedEvent variableCreatedEvent) {
        String processInstanceId = ((VariableInstance)variableCreatedEvent.getEntity()).getProcessInstanceId();
        String variableName = ((VariableInstance)variableCreatedEvent.getEntity()).getName();
        this.entityManagerFinder.findProcessInstanceWithVariables(processInstanceId).ifPresent(processInstanceEntity -> processInstanceEntity.getVariable(variableName).ifPresentOrElse(variableEntity -> LOGGER.warn("Variable " + variableName + " already exists in the process " + processInstanceId + "!"), () -> {
            ProcessVariableEntity variableEntity = this.createProcessVariableEntity(variableCreatedEvent, (ProcessInstanceEntity)processInstanceEntity);
            processInstanceEntity.getVariables().add(variableEntity);
            this.assignToTasks(processInstanceId, variableName, variableEntity);
        }));
    }

    private ProcessVariableEntity createProcessVariableEntity(CloudVariableCreatedEvent variableCreatedEvent, ProcessInstanceEntity processInstanceEntity) {
        ProcessVariableEntity variableEntity = new ProcessVariableEntity((CloudVariableEvent)variableCreatedEvent);
        variableEntity.setValue(((VariableInstance)variableCreatedEvent.getEntity()).getValue());
        variableEntity.setVariableDefinitionId(variableCreatedEvent.getVariableDefinitionId());
        variableEntity.setProcessDefinitionKey(variableCreatedEvent.getProcessDefinitionKey());
        variableEntity.setProcessInstance(processInstanceEntity);
        this.entityManager.persist((Object)variableEntity);
        return variableEntity;
    }

    private void assignToTasks(String processInstanceId, String variableName, ProcessVariableEntity variableEntity) {
        this.entityManagerFinder.findTasksWithProcessVariables(processInstanceId).forEach(taskEntity -> {
            Set processVariables = taskEntity.getProcessVariables();
            if (processVariables.stream().map(AbstractVariableEntity::getName).anyMatch(variableName::equals)) {
                LOGGER.warn("Process variable " + variableName + " already exists in the task " + taskEntity.getId() + "!");
            } else {
                taskEntity.getProcessVariables().add(variableEntity);
            }
        });
    }
}

