/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.activiti.cloud.api.model.shared.QueryCloudVariableInstance;
import org.activiti.cloud.api.model.shared.events.CloudVariableEvent;
import org.activiti.cloud.services.query.model.AbstractVariableEntity;
import org.activiti.cloud.services.query.model.ActivitiEntityMetadata;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.VariableValue;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;

@FilterDef(name="variablesFilter", parameters={@ParamDef(name="variableKeys", type=String.class)}, defaultCondition="concat(process_definition_key, '/', name) in (:variableKeys)")
@Entity(name="ProcessVariable")
@Table(name="PROCESS_VARIABLE", indexes={@Index(name="proc_var_processInstanceId_idx", columnList="processInstanceId", unique=false), @Index(name="proc_var_name_idx", columnList="name", unique=false), @Index(name="proc_var_executionId_idx", columnList="executionId", unique=false)})
@DynamicInsert
@DynamicUpdate
@EnhancementInfo(version="6.5.3.Final")
public class ProcessVariableEntity
extends AbstractVariableEntity
implements QueryCloudVariableInstance,
ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @GeneratedValue(generator="process_variable_sequence", strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(name="process_variable_sequence", sequenceName="process_variable_sequence", allocationSize=50)
    Long id;
    String variableDefinitionId;
    Boolean ephemeral;
    @Schema(description="The business key associated to the process instance. It could be useful to add a reference to external systems.", readOnly=true)
    String processDefinitionKey;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public ProcessVariableEntity() {
    }

    public ProcessVariableEntity(Long id, String type, String name, String processInstanceId, String serviceName, String serviceFullName, String serviceVersion, String appName, String appVersion, Date createTime, Date lastUpdatedTime, String executionId, boolean ephemeral) {
        super(type, name, processInstanceId, serviceName, serviceFullName, serviceVersion, appName, appVersion, createTime, lastUpdatedTime, executionId);
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_ephemeral(ephemeral);
    }

    public ProcessVariableEntity(CloudVariableEvent variableEvent) {
        super(variableEvent);
        this.$$_hibernate_write_ephemeral(variableEvent.isEphemeralVariable());
    }

    @Override
    public Long getId() {
        return this.$$_hibernate_read_id();
    }

    public String getTaskId() {
        return null;
    }

    public boolean isTaskVariable() {
        return false;
    }

    public String getVariableDefinitionId() {
        return this.$$_hibernate_read_variableDefinitionId();
    }

    public void setVariableDefinitionId(String variableDefinitionId) {
        this.$$_hibernate_write_variableDefinitionId(variableDefinitionId);
    }

    public String getProcessDefinitionKey() {
        return this.$$_hibernate_read_processDefinitionKey();
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.$$_hibernate_write_processDefinitionKey(processDefinitionKey);
    }

    public boolean isEphemeral() {
        return Optional.ofNullable(this.$$_hibernate_read_ephemeral()).orElse(false);
    }

    public void setEphemeral(Boolean ephemeral) {
        this.$$_hibernate_write_ephemeral(ephemeral);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessVariableEntity other = (ProcessVariableEntity)obj;
        return this.getId() != null && Objects.equals(this.getId(), other.getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        ProcessVariableEntity processVariableEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        ProcessVariableEntity processVariableEntity = this;
        processVariableEntity = null;
        processVariableEntity = NoopCollectionTracker.INSTANCE;
        return processVariableEntity;
    }

    @Override
    public String $$_hibernate_read_type() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_type((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "type", (Object)super.$$_hibernate_read_type()));
        }
        return super.$$_hibernate_read_type();
    }

    @Override
    public void $$_hibernate_write_type(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"type", (Object)string, (Object)((AbstractVariableEntity)this).$$_hibernate_read_type())) {
            this.$$_hibernate_trackChange("type");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_type((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "type", (Object)super.$$_hibernate_read_type(), (Object)string));
            return;
        }
        super.$$_hibernate_write_type(string);
    }

    @Override
    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_name((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)super.$$_hibernate_read_name()));
        }
        return super.$$_hibernate_read_name();
    }

    @Override
    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)((AbstractVariableEntity)this).$$_hibernate_read_name())) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_name((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)super.$$_hibernate_read_name(), (Object)string));
            return;
        }
        super.$$_hibernate_write_name(string);
    }

    @Override
    public Date $$_hibernate_read_createTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createTime((Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "createTime", (Object)super.$$_hibernate_read_createTime()));
        }
        return super.$$_hibernate_read_createTime();
    }

    @Override
    public void $$_hibernate_write_createTime(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createTime", (Object)date, (Object)((AbstractVariableEntity)this).$$_hibernate_read_createTime())) {
            this.$$_hibernate_trackChange("createTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_createTime((Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createTime", (Object)super.$$_hibernate_read_createTime(), (Object)date));
            return;
        }
        super.$$_hibernate_write_createTime(date);
    }

    @Override
    public Date $$_hibernate_read_lastUpdatedTime() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastUpdatedTime((Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastUpdatedTime", (Object)super.$$_hibernate_read_lastUpdatedTime()));
        }
        return super.$$_hibernate_read_lastUpdatedTime();
    }

    @Override
    public void $$_hibernate_write_lastUpdatedTime(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastUpdatedTime", (Object)date, (Object)((AbstractVariableEntity)this).$$_hibernate_read_lastUpdatedTime())) {
            this.$$_hibernate_trackChange("lastUpdatedTime");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_lastUpdatedTime((Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastUpdatedTime", (Object)super.$$_hibernate_read_lastUpdatedTime(), (Object)date));
            return;
        }
        super.$$_hibernate_write_lastUpdatedTime(date);
    }

    @Override
    public String $$_hibernate_read_executionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_executionId((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "executionId", (Object)super.$$_hibernate_read_executionId()));
        }
        return super.$$_hibernate_read_executionId();
    }

    @Override
    public void $$_hibernate_write_executionId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"executionId", (Object)string, (Object)((AbstractVariableEntity)this).$$_hibernate_read_executionId())) {
            this.$$_hibernate_trackChange("executionId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_executionId((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "executionId", (Object)super.$$_hibernate_read_executionId(), (Object)string));
            return;
        }
        super.$$_hibernate_write_executionId(string);
    }

    @Override
    public VariableValue $$_hibernate_read_value() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_value((VariableValue)this.$$_hibernate_getInterceptor().readObject((Object)this, "value", (Object)super.$$_hibernate_read_value()));
        }
        return super.$$_hibernate_read_value();
    }

    @Override
    public void $$_hibernate_write_value(VariableValue variableValue) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"value", (Object)variableValue, (Object)((AbstractVariableEntity)this).$$_hibernate_read_value())) {
            this.$$_hibernate_trackChange("value");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_value((VariableValue)this.$$_hibernate_getInterceptor().writeObject((Object)this, "value", (Object)super.$$_hibernate_read_value(), (Object)variableValue));
            return;
        }
        super.$$_hibernate_write_value(variableValue);
    }

    @Override
    public Boolean $$_hibernate_read_markedAsDeleted() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_markedAsDeleted((Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "markedAsDeleted", (Object)super.$$_hibernate_read_markedAsDeleted()));
        }
        return super.$$_hibernate_read_markedAsDeleted();
    }

    @Override
    public void $$_hibernate_write_markedAsDeleted(Boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"markedAsDeleted", (Object)bl, (Object)((AbstractVariableEntity)this).$$_hibernate_read_markedAsDeleted())) {
            this.$$_hibernate_trackChange("markedAsDeleted");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_markedAsDeleted((Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "markedAsDeleted", (Object)super.$$_hibernate_read_markedAsDeleted(), (Object)bl));
            return;
        }
        super.$$_hibernate_write_markedAsDeleted(bl);
    }

    @Override
    public String $$_hibernate_read_processInstanceId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_processInstanceId((String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processInstanceId", (Object)super.$$_hibernate_read_processInstanceId()));
        }
        return super.$$_hibernate_read_processInstanceId();
    }

    @Override
    public void $$_hibernate_write_processInstanceId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processInstanceId", (Object)string, (Object)((AbstractVariableEntity)this).$$_hibernate_read_processInstanceId())) {
            this.$$_hibernate_trackChange("processInstanceId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_processInstanceId((String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processInstanceId", (Object)super.$$_hibernate_read_processInstanceId(), (Object)string));
            return;
        }
        super.$$_hibernate_write_processInstanceId(string);
    }

    @Override
    public ProcessInstanceEntity $$_hibernate_read_processInstance() {
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_processInstance((ProcessInstanceEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "processInstance", (Object)super.$$_hibernate_read_processInstance()));
        }
        return super.$$_hibernate_read_processInstance();
    }

    @Override
    public void $$_hibernate_write_processInstance(ProcessInstanceEntity processInstanceEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processInstance", (Object)processInstanceEntity, (Object)((AbstractVariableEntity)this).$$_hibernate_read_processInstance())) {
            this.$$_hibernate_trackChange("processInstance");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            super.$$_hibernate_write_processInstance((ProcessInstanceEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processInstance", (Object)super.$$_hibernate_read_processInstance(), (Object)processInstanceEntity));
            return;
        }
        super.$$_hibernate_write_processInstance(processInstanceEntity);
    }

    @Override
    public String $$_hibernate_read_serviceName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceName", (Object)this.serviceName);
        }
        return this.serviceName;
    }

    @Override
    public void $$_hibernate_write_serviceName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceName())) {
            this.$$_hibernate_trackChange("serviceName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceName", (Object)this.serviceName, (Object)string);
            return;
        }
        this.serviceName = string;
    }

    @Override
    public String $$_hibernate_read_serviceFullName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceFullName", (Object)this.serviceFullName);
        }
        return this.serviceFullName;
    }

    @Override
    public void $$_hibernate_write_serviceFullName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceFullName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceFullName())) {
            this.$$_hibernate_trackChange("serviceFullName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceFullName", (Object)this.serviceFullName, (Object)string);
            return;
        }
        this.serviceFullName = string;
    }

    @Override
    public String $$_hibernate_read_serviceVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceVersion", (Object)this.serviceVersion);
        }
        return this.serviceVersion;
    }

    @Override
    public void $$_hibernate_write_serviceVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceVersion())) {
            this.$$_hibernate_trackChange("serviceVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceVersion", (Object)this.serviceVersion, (Object)string);
            return;
        }
        this.serviceVersion = string;
    }

    @Override
    public String $$_hibernate_read_appName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appName", (Object)this.appName);
        }
        return this.appName;
    }

    @Override
    public void $$_hibernate_write_appName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appName())) {
            this.$$_hibernate_trackChange("appName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appName", (Object)this.appName, (Object)string);
            return;
        }
        this.appName = string;
    }

    @Override
    public String $$_hibernate_read_appVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appVersion", (Object)this.appVersion);
        }
        return this.appVersion;
    }

    @Override
    public void $$_hibernate_write_appVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appVersion())) {
            this.$$_hibernate_trackChange("appVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appVersion", (Object)this.appVersion, (Object)string);
            return;
        }
        this.appVersion = string;
    }

    @Override
    public String $$_hibernate_read_serviceType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceType", (Object)this.serviceType);
        }
        return this.serviceType;
    }

    @Override
    public void $$_hibernate_write_serviceType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceType", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceType())) {
            this.$$_hibernate_trackChange("serviceType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceType", (Object)this.serviceType, (Object)string);
            return;
        }
        this.serviceType = string;
    }

    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)l);
            return;
        }
        this.id = l;
    }

    public String $$_hibernate_read_variableDefinitionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.variableDefinitionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "variableDefinitionId", (Object)this.variableDefinitionId);
        }
        return this.variableDefinitionId;
    }

    public void $$_hibernate_write_variableDefinitionId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"variableDefinitionId", (Object)string, (Object)this.variableDefinitionId)) {
            this.$$_hibernate_trackChange("variableDefinitionId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.variableDefinitionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "variableDefinitionId", (Object)this.variableDefinitionId, (Object)string);
            return;
        }
        this.variableDefinitionId = string;
    }

    public Boolean $$_hibernate_read_ephemeral() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ephemeral = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "ephemeral", (Object)this.ephemeral);
        }
        return this.ephemeral;
    }

    public void $$_hibernate_write_ephemeral(Boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"ephemeral", (Object)bl, (Object)this.ephemeral)) {
            this.$$_hibernate_trackChange("ephemeral");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ephemeral = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "ephemeral", (Object)this.ephemeral, (Object)bl);
            return;
        }
        this.ephemeral = bl;
    }

    public String $$_hibernate_read_processDefinitionKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionKey", (Object)this.processDefinitionKey);
        }
        return this.processDefinitionKey;
    }

    public void $$_hibernate_write_processDefinitionKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionKey", (Object)string, (Object)this.processDefinitionKey)) {
            this.$$_hibernate_trackChange("processDefinitionKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionKey", (Object)this.processDefinitionKey, (Object)string);
            return;
        }
        this.processDefinitionKey = string;
    }
}

