/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.VariableValue;

public class VariableValueJsonConverter
implements AttributeConverter<VariableValue<?>, String> {
    private static ObjectMapper objectMapper;

    public VariableValueJsonConverter() {
    }

    public VariableValueJsonConverter(ObjectMapper objectMapper) {
        VariableValueJsonConverter.objectMapper = objectMapper;
    }

    public String convertToDatabaseColumn(VariableValue<?> variableValue) {
        try {
            return objectMapper.writeValueAsString(variableValue);
        }
        catch (JsonProcessingException e) {
            throw new QueryException("Unable to serialize variable.", e);
        }
    }

    public VariableValue<?> convertToEntityAttribute(String dbData) {
        try {
            if (dbData != null && dbData.length() > 0) {
                return (VariableValue)objectMapper.readValue(dbData, VariableValue.class);
            }
            return new VariableValue<Object>(null);
        }
        catch (IOException e) {
            throw new QueryException("Unable to deserialize variable.", e);
        }
    }
}

