/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.app.repository;

import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.activiti.cloud.services.query.app.repository.CustomizedJpaSpecificationExecutor;
import org.activiti.cloud.services.query.app.repository.annotation.CountOverFullWindow;
import org.activiti.cloud.services.query.app.repository.function.CustomSQLFunction;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CustomizedJpaSpecificationExecutorImpl<T, I extends Serializable>
extends SimpleJpaRepository<T, I>
implements CustomizedJpaSpecificationExecutor<T> {
    private final EntityManager entityManager;

    public CustomizedJpaSpecificationExecutorImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
    }

    protected <S extends T> TypedQuery<Long> getCountQuery(@Nullable Specification<S> spec, Class<S> domainClass) {
        if (spec != null && spec.getClass().isAnnotationPresent(CountOverFullWindow.class)) {
            CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Long.class);
            Assert.notNull(domainClass, (String)"Domain class must not be null");
            Predicate predicate = spec.toPredicate(query.from(domainClass), query, builder);
            if (!CollectionUtils.isEmpty((Collection)query.getGroupList())) {
                if (predicate != null) {
                    query.where((Expression)predicate);
                }
                query.select((Selection)builder.function(CustomSQLFunction.COUNT_OVER_FULL_WINDOW.name(), Long.class, new Expression[0]));
                query.orderBy(Collections.emptyList());
                TypedQuery typedQuery = this.entityManager.createQuery(query);
                typedQuery.setMaxResults(1);
                return typedQuery;
            }
        }
        return super.getCountQuery(spec, domainClass);
    }
}

