/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.app.repository;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.List;
import org.activiti.cloud.services.query.app.repository.CustomizedTaskRepository;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.model.QTaskVariableEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.model.VariableValue;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.jpa.repository.support.QuerydslRepositorySupport;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;

public class CustomizedTaskRepositoryImpl
extends QuerydslRepositorySupport
implements CustomizedTaskRepository {
    public CustomizedTaskRepositoryImpl() {
        super(TaskEntity.class);
    }

    @Override
    public Page<TaskEntity> findByVariableNameAndValue(String name, VariableValue<?> value, Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)name, (String)"name must not be null!");
        Assert.notNull(value, (String)"value must not be null!");
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        EntityManager entityManager = this.getEntityManager();
        Querydsl querydsl = this.getQuerydsl();
        JPAQueryFactory queryFactory = new JPAQueryFactory(entityManager);
        QTaskEntity taskEntity = QTaskEntity.taskEntity;
        QTaskVariableEntity variableEntity = QTaskVariableEntity.taskVariableEntity;
        BooleanExpression condition = variableEntity.name.eq((Object)name).and((Predicate)Expressions.booleanTemplate((String)"{0} = {1}", (Object[])new Object[]{variableEntity.value, value}));
        JPAQuery taskIdsQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)queryFactory.query().select((Expression)taskEntity.id).from((EntityPath)taskEntity)).innerJoin((CollectionExpression)taskEntity.variables, (Path)variableEntity)).on((Predicate)condition)).where(predicate);
        long totalElements = taskIdsQuery.fetchCount();
        List taskIds = querydsl.applyPagination(pageable, (JPQLQuery)taskIdsQuery).fetch();
        JPQLQuery tasksQuery = (JPQLQuery)((JPAQuery)((JPAQuery)((JPAQuery)queryFactory.query().select((Expression)taskEntity).from((EntityPath)taskEntity)).innerJoin((CollectionExpression)taskEntity.variables, (Path)variableEntity)).on((Predicate)condition)).where((Predicate)taskEntity.id.in((Collection)taskIds));
        return PageableExecutionUtils.getPage((List)querydsl.applySorting(pageable.getSort(), tasksQuery).fetch(), (Pageable)pageable, () -> totalElements);
    }

    @Override
    public Iterable<TaskEntity> findInProcessInstanceScope(Predicate predicate) {
        QTaskEntity taskEntity = QTaskEntity.taskEntity;
        JPQLQuery<TaskEntity> from = this.buildLeftJoin(taskEntity, predicate);
        JPQLQuery tasks = from.select((Expression)taskEntity);
        return tasks.fetch();
    }

    @Override
    public Page<TaskEntity> findInProcessInstanceScope(Predicate predicate, Pageable pageable) {
        QTaskEntity taskEntity = QTaskEntity.taskEntity;
        Querydsl querydsl = this.getQuerydsl();
        JPQLQuery taskIdsQuery = (JPQLQuery)this.buildLeftJoin(taskEntity).select((Expression)taskEntity.id).where(new Predicate[]{predicate});
        long totalElements = taskIdsQuery.fetchCount();
        List taskIds = querydsl.applyPagination(pageable, taskIdsQuery).fetch();
        JPQLQuery tasks = (JPQLQuery)this.buildLeftJoin(taskEntity).select((Expression)taskEntity).where(new Predicate[]{taskEntity.id.in((Collection)taskIds)});
        return PageableExecutionUtils.getPage((List)querydsl.applySorting(pageable.getSort(), tasks).fetch(), (Pageable)pageable, () -> totalElements);
    }

    @Override
    public boolean existsInProcessInstanceScope(Predicate predicate) {
        QTaskEntity taskEntity = QTaskEntity.taskEntity;
        JPQLQuery<TaskEntity> from = this.buildLeftJoin(taskEntity, predicate);
        JPQLQuery countQuery = from.select((Expression)taskEntity.count());
        return countQuery.fetchCount() > 0L;
    }

    private JPQLQuery<TaskEntity> buildLeftJoin(QTaskEntity taskEntity, Predicate predicate) {
        return (JPQLQuery)this.buildLeftJoin(taskEntity).where(new Predicate[]{predicate});
    }

    private JPQLQuery<TaskEntity> buildLeftJoin(QTaskEntity taskEntity) {
        QProcessInstanceEntity processInstanceEntity = QProcessInstanceEntity.processInstanceEntity;
        BooleanExpression condition = processInstanceEntity.id.eq((Expression)taskEntity.processInstanceId);
        return this.from((EntityPath)taskEntity).leftJoin((EntityPath)processInstanceEntity).on(new Predicate[]{condition});
    }
}

