/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.app.repository;

import com.querydsl.core.types.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.activiti.cloud.services.query.app.repository.CustomizedProcessInstanceRepository;
import org.activiti.cloud.services.query.app.repository.QuerydslBindingsHelper;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.binding.QuerydslBinderCustomizer;
import org.springframework.data.querydsl.binding.QuerydslBindings;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface ProcessInstanceRepository
extends PagingAndSortingRepository<ProcessInstanceEntity, String>,
JpaSpecificationExecutor<ProcessInstanceEntity>,
QuerydslPredicateExecutor<ProcessInstanceEntity>,
QuerydslBinderCustomizer<QProcessInstanceEntity>,
CustomizedProcessInstanceRepository,
CrudRepository<ProcessInstanceEntity, String> {
    default public void customize(QuerydslBindings bindings, QProcessInstanceEntity root) {
        QuerydslBindingsHelper.whitelist(root).apply(bindings);
        bindings.bind(String.class).first((path, value) -> path.eq(value));
        bindings.bind((Path)root.lastModifiedFrom).first((path, value) -> root.lastModified.after((Comparable)value));
        bindings.bind((Path)root.lastModifiedTo).first((path, value) -> root.lastModified.before((Comparable)value));
        bindings.bind((Path)root.startFrom).first((path, value) -> root.startDate.after((Comparable)value));
        bindings.bind((Path)root.startTo).first((path, value) -> root.startDate.before((Comparable)value));
        bindings.bind((Path)root.completedFrom).first((path, value) -> root.completedDate.after((Comparable)value));
        bindings.bind((Path)root.completedTo).first((path, value) -> root.completedDate.before((Comparable)value));
        bindings.bind((Path)root.suspendedFrom).first((path, value) -> root.suspendedDate.after((Comparable)value));
        bindings.bind((Path)root.suspendedTo).first((path, value) -> root.suspendedDate.before((Comparable)value));
        bindings.bind((Path)root.name).first((path, value) -> path.like("%" + value.toString() + "%"));
        bindings.bind((Path)root.initiator).first((path, value) -> root.initiator.in(Arrays.asList(value.split(","))));
        bindings.bind((Path)root.appVersion).first((path, value) -> root.appVersion.in(Arrays.asList(value.split(","))));
    }

    @EntityGraph(value="ProcessInstances.withVariables", type=EntityGraph.EntityGraphType.LOAD)
    public List<ProcessInstanceEntity> findByIdIsIn(Collection<String> var1, Sort var2);
}

