/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.app.repository;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.persistence.EntityManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.cloud.api.process.model.QueryCloudSubprocessInstance;
import org.activiti.cloud.services.query.app.repository.CustomizedProcessInstanceRepository;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QProcessInstanceEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.jpa.repository.support.QuerydslRepositorySupport;
import org.springframework.data.support.PageableExecutionUtils;

public class CustomizedProcessInstanceRepositoryImpl
extends QuerydslRepositorySupport
implements CustomizedProcessInstanceRepository {
    private final JPAQueryFactory queryFactory;

    public CustomizedProcessInstanceRepositoryImpl(EntityManager entityManager) {
        super(ProcessInstanceEntity.class);
        this.queryFactory = new JPAQueryFactory(entityManager);
    }

    @Override
    public Page<ProcessInstanceEntity> mapSubprocesses(Page<ProcessInstanceEntity> processInstances, Pageable pageable) {
        List<String> parentIds = this.getParentIds(processInstances);
        Page<ProcessInstanceEntity> subprocesses = this.findSubprocessesByParentIds(parentIds, pageable);
        Map<String, Set<QueryCloudSubprocessInstance>> subprocessMap = this.groupSubprocesses(subprocesses);
        this.setSubprocesses(processInstances, subprocessMap);
        return processInstances;
    }

    @Override
    public ProcessInstanceEntity mapSubprocesses(ProcessInstanceEntity processInstance) {
        List<ProcessInstanceEntity> subprocesses = this.findSubprocessesByParentId(processInstance.getId());
        if (subprocesses == null || subprocesses.isEmpty()) {
            processInstance.setSubprocesses(new HashSet());
            return processInstance;
        }
        Set subprocessSet = subprocesses.stream().map(this::getQueryCloudSubprocessInstance).collect(Collectors.toSet());
        processInstance.setSubprocesses(subprocessSet);
        return processInstance;
    }

    public QueryCloudSubprocessInstance getQueryCloudSubprocessInstance(ProcessInstanceEntity subprocess) {
        QueryCloudSubprocessInstance subProcessInstance = new QueryCloudSubprocessInstance();
        subProcessInstance.setId(subprocess.getId());
        subProcessInstance.setProcessDefinitionName(subprocess.getProcessDefinitionName());
        return subProcessInstance;
    }

    public List<String> getParentIds(Page<ProcessInstanceEntity> processInstances) {
        return processInstances.getContent().stream().map(ProcessInstanceEntity::getId).toList();
    }

    public Map<String, Set<QueryCloudSubprocessInstance>> groupSubprocesses(Page<ProcessInstanceEntity> subprocesses) {
        return subprocesses.getContent().stream().collect(Collectors.groupingBy(ProcessInstanceEntity::getParentId, Collectors.mapping(this::getQueryCloudSubprocessInstance, Collectors.toSet())));
    }

    public void setSubprocesses(Page<ProcessInstanceEntity> processInstances, Map<String, Set<QueryCloudSubprocessInstance>> subprocessMap) {
        processInstances.getContent().forEach(processInstance -> {
            Set subprocessSet = subprocessMap.getOrDefault(processInstance.getId(), Set.of());
            processInstance.setSubprocesses(subprocessSet);
        });
    }

    public Page<ProcessInstanceEntity> findSubprocessesByParentIds(List<String> parentIds, Pageable pageable) {
        QProcessInstanceEntity processInstanceEntity = QProcessInstanceEntity.processInstanceEntity;
        Querydsl querydsl = this.getQuerydsl();
        JPQLQuery subprocessQuery = (JPQLQuery)this.queryFactory.selectFrom((EntityPath)processInstanceEntity).where((Predicate)processInstanceEntity.parentId.in(parentIds));
        long totalElements = subprocessQuery.fetchCount();
        assert (querydsl != null);
        List subprocesses = querydsl.applyPagination(pageable, subprocessQuery).fetch();
        return PageableExecutionUtils.getPage((List)subprocesses, (Pageable)pageable, () -> totalElements);
    }

    public List<ProcessInstanceEntity> findSubprocessesByParentId(String parentId) {
        QProcessInstanceEntity processInstanceEntity = QProcessInstanceEntity.processInstanceEntity;
        return ((JPAQuery)this.queryFactory.selectFrom((EntityPath)processInstanceEntity).where((Predicate)processInstanceEntity.parentId.eq((Object)parentId))).fetch();
    }
}

